/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.blocks.BlockLightCollector;
import wolforce.blocks.BlockSeparator;
import wolforce.blocks.BlockTube;
import wolforce.recipes.RecipeSeparator;

public class TileSeparator
extends TileEntity
implements ITickable {
    static final int MAX_CHARGE = 100;
    static final String[][][] multiblock = new String[][][]{{{null, null, "L1", null, null}, {null, "HB", "L1", "HB", null}, {"L1", "L1", "L0", "L1", "L1"}, {null, "HB", "PB", "HB", null}}, {{null, null, null, null, null}, {null, "PB", "PB", "PB", null}, {null, "HB", "PB", "HB", null}, {null, "AR", "00", "AR", null}}, {{null, null, null, null, null}, {null, null, null, null, null}, {null, "FT", "AR", "FT", null}, {null, null, null, null, null}}, {{null, null, null, null, null}, {null, null, null, null, null}, {null, "LC", "AR", "LC", null}, {null, null, null, null, null}}};
    public ItemStackHandler inventory = new ItemStackHandler(1);
    int charge = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_175640_z(this.field_174879_c) || this.field_145850_b.func_175640_z(this.field_174879_c.func_177977_b())) {
            return;
        }
        if (!Util.isValid(this.inventory.getStackInSlot(0))) {
            return;
        }
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(block.func_177230_c() instanceof BlockSeparator)) {
            return;
        }
        EnumFacing facing = (EnumFacing)block.func_177229_b(BlockSeparator.FACING);
        ItemStack[] result = RecipeSeparator.getResult(this.inventory.getStackInSlot(0));
        if (result != null) {
            HashMap<String, Util.BlockWithMeta> table = new HashMap<String, Util.BlockWithMeta>();
            table.put("PB", new Util.BlockWithMeta(Main.heavy_protection_block));
            table.put("HB", new Util.BlockWithMeta(Main.heat_block));
            table.put("FT", new Util.BlockWithMeta(Main.furnace_tube, Main.furnace_tube.func_176201_c(Main.furnace_tube.func_176223_P().func_177226_a((IProperty)BlockTube.field_176298_M, (Comparable)EnumFacing.Axis.Y)), new boolean[0]));
            int metaSource = Main.liquid_souls_block.func_176201_c(Main.liquid_souls_block.func_176194_O().func_177621_b());
            table.put("L0", new Util.BlockWithMeta(Main.liquid_souls_block, metaSource, new boolean[0]));
            table.put("L1", new Util.BlockWithMeta(Main.liquid_souls_block, metaSource, true));
            table.put("LC", new Util.BlockWithMeta(Main.light_collector, Main.light_collector.func_176201_c(Main.light_collector.func_176223_P().func_177226_a((IProperty)BlockLightCollector.CHARGE, (Comparable)Integer.valueOf(3))), new boolean[0]));
            table.put("AR", new Util.BlockWithMeta(Blocks.field_150350_a));
            if (Util.isMultiblockBuilt(this.field_145850_b, this.field_174879_c, facing, multiblock, table) && this.chargeup()) {
                this.done(facing);
            }
        }
    }

    private void done(EnumFacing facing) {
        if (!BlockEnergyConsumer.tryConsume(this.field_145850_b, this.field_174879_c, HwellConfig.machines.separatorConsumption)) {
            return;
        }
        ItemStack[] result = RecipeSeparator.getResult(this.inventory.extractItem(0, 1, false));
        this.func_70296_d();
        BlockPos leftPos = this.field_174879_c.func_177972_a(facing.func_176735_f()).func_177972_a(facing).func_177972_a(EnumFacing.DOWN);
        Util.spawnItem(this.field_145850_b, leftPos, result[0], 0.0, 0.0, 0.0);
        BlockPos rightPos = this.field_174879_c.func_177972_a(facing.func_176746_e()).func_177972_a(facing).func_177972_a(EnumFacing.DOWN);
        Util.spawnItem(this.field_145850_b, rightPos, result[1], 0.0, 0.0, 0.0);
        if (!result[2].equals(ItemStack.field_190927_a)) {
            BlockPos backPos = this.field_174879_c.func_177972_a(facing).func_177972_a(facing).func_177972_a(EnumFacing.DOWN);
            Util.spawnItem(this.field_145850_b, backPos, result[2], 0.0, 0.0, 0.0);
        }
    }

    private boolean chargeup() {
        ++this.charge;
        if (this.charge >= 100) {
            this.charge = 0;
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("charge", this.charge);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.charge = compound.func_74762_e("charge");
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        super.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

