/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.blocks.BlockLightCollector;
import wolforce.blocks.BlockTube;
import wolforce.recipes.RecipePuller;

public class TilePuller
extends TileEntity
implements ITickable {
    String[][][] multiblock = new String[][][]{{{"PB", "PB", "PB"}, {"PB", "00", "PB"}, {"PB", "PB", "PB"}}, {{"HB", "HB", "HB"}, {"HB", "L0", "HB"}, {"HB", "HB", "HB"}}, {{"TU", null, "TU"}, {null, null, null}, {"TU", null, "TU"}}, {{"LC", null, "LC"}, {null, null, null}, {"LC", null, "LC"}}};
    String[][][] multiblock2 = new String[][][]{{{null, "PB", null}, {"PB", "00", "PB"}, {null, "PB", null}}};
    static final int MAX_COOLDOWN = HwellConfig.machines.pullerDelay;
    int cooldown = MAX_COOLDOWN;

    public void func_73660_a() {
        ItemStack result;
        if (this.field_145850_b.field_72995_K || this.isPowered()) {
            return;
        }
        if (this.cooldown > 0) {
            this.cooldown -= 5;
            return;
        }
        HashMap<String, Util.BlockWithMeta> table = new HashMap<String, Util.BlockWithMeta>();
        table.put("PB", new Util.BlockWithMeta(Main.heavy_protection_block));
        table.put("HB", new Util.BlockWithMeta(Main.heat_block));
        table.put("L0", new Util.BlockWithMeta(Main.liquid_souls_block));
        table.put("TU", new Util.BlockWithMeta(Main.furnace_tube, Main.furnace_tube.func_176201_c(Main.furnace_tube.func_176223_P().func_177226_a((IProperty)BlockTube.field_176298_M, (Comparable)EnumFacing.Axis.Y)), new boolean[0]));
        table.put("LC", new Util.BlockWithMeta(Main.light_collector, Main.light_collector.func_176201_c(Main.light_collector.func_176223_P().func_177226_a((IProperty)BlockLightCollector.CHARGE, (Comparable)Integer.valueOf(3))), new boolean[0]));
        List entityList = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177984_a()));
        LinkedList<ItemStack> filtersInLiquid = new LinkedList<ItemStack>();
        if (!entityList.isEmpty()) {
            for (EntityItem entityItem : entityList) {
                if (!RecipePuller.isFilter(entityItem.func_92059_d())) continue;
                filtersInLiquid.add(entityItem.func_92059_d());
            }
        }
        if (Util.isMultiblockBuilt(this.field_145850_b, this.field_174879_c, EnumFacing.EAST, this.multiblock, table) && Util.isValid(result = RecipePuller.getRandomPull(filtersInLiquid))) {
            if (!BlockEnergyConsumer.tryConsume(this.field_145850_b, this.field_174879_c, Main.puller.getEnergyConsumption())) {
                return;
            }
            this.cooldown = MAX_COOLDOWN - 50 * this.getNrExtraLayers(table);
            Util.spawnItem(this.field_145850_b, this.field_174879_c, result, 0.0, 0.4, 0.0);
        }
    }

    private boolean isPowered() {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (!this.field_145850_b.func_175640_z(new BlockPos(this.field_174879_c.func_177958_n() + dx, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + dz))) continue;
                return true;
            }
        }
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    private int getNrExtraLayers(HashMap<String, Util.BlockWithMeta> table) {
        BlockPos posn = this.field_174879_c.func_177977_b();
        int n = 0;
        while (Util.blockAt(this.field_145850_b, posn).equals(Main.furnace_tube) && Util.isMultiblockBuilt(this.field_145850_b, posn, EnumFacing.EAST, this.multiblock2, table)) {
            ++n;
            posn = posn.func_177977_b();
        }
        return n;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cooldown", this.cooldown);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooldown = compound.func_74762_e("cooldown");
    }
}

