/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.blocks.BlockPrecisionGrinder;
import wolforce.blocks.BlockPrecisionGrinderEmpty;
import wolforce.items.ItemGrindingWheel;
import wolforce.recipes.RecipeGrinding;

public class TilePrecisionGrinder
extends TileEntity
implements ITickable {
    String[][][] multiblock = new String[][][]{{{"HB", "SL", "HB"}, {"PB", "00", "PB"}, {"HB", "PB", "HB"}}, {{null, "PB", null}, {"PB", "AR", "AR"}, {null, "PB", null}}, {{null, "PB", null}, {"PB", "SL", "AR"}, {null, "PB", null}}};
    int cooldown = 0;
    static final int MAX_COOLDOWN = 100;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cooldown > 0) {
            this.cooldown -= 5;
            return;
        }
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(block.func_177230_c() instanceof BlockPrecisionGrinder)) {
            return;
        }
        BlockPrecisionGrinder grinder = (BlockPrecisionGrinder)block.func_177230_c();
        EnumFacing facing = (EnumFacing)block.func_177229_b(BlockPrecisionGrinder.FACING);
        List entities = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.field_174879_c.func_177956_o() + 1.5, (double)(this.field_174879_c.func_177952_p() + 1)));
        if (entities.size() > 0) {
            EntityItem entityItem;
            ItemGrindingWheel gwheel;
            ItemStack result;
            HashMap<String, Util.BlockWithMeta> table = new HashMap<String, Util.BlockWithMeta>();
            table.put("PB", new Util.BlockWithMeta(Main.protection_block));
            table.put("HB", new Util.BlockWithMeta(Main.heavy_block));
            table.put("SL", new Util.BlockWithMeta(Main.slab_lamp, EnumFacing.DOWN.ordinal(), new boolean[0]));
            table.put("AR", new Util.BlockWithMeta(Blocks.field_150350_a));
            if (Util.isMultiblockBuilt(this.field_145850_b, this.field_174879_c, facing, this.multiblock, table) && Util.isValid(result = RecipeGrinding.getResult(gwheel = ((BlockPrecisionGrinder)block.func_177230_c()).grindingWheel, (entityItem = (EntityItem)entities.get(0)).func_92059_d()))) {
                if (!BlockEnergyConsumer.tryConsume(this.field_145850_b, this.field_174879_c, grinder.getEnergyConsumption())) {
                    return;
                }
                this.output(result, facing);
                entityItem.func_92059_d().func_190918_g(1);
                this.cooldown = 100;
                double prob = Math.pow(entityItem.func_92059_d().func_190916_E(), 4.0) / 3.33333E7;
                if (entityItem.func_92059_d().func_190916_E() > 20 && Math.random() < prob) {
                    this.popGrindingWheel(entityItem, gwheel, facing);
                }
            }
        }
    }

    private void output(ItemStack result, EnumFacing facing) {
        BlockPos newpos = this.field_174879_c.func_177972_a(facing);
        EntityItem newentity = new EntityItem(this.field_145850_b, (double)newpos.func_177958_n() + 0.5, (double)newpos.func_177956_o(), (double)newpos.func_177952_p() + 0.5, new ItemStack(result.func_77973_b(), result.func_190916_E(), result.func_77960_j()));
        Util.spawnItem(this.field_145850_b, newpos, result, facing);
    }

    private void popGrindingWheel(EntityItem entityItem, ItemGrindingWheel gwheel, EnumFacing facing) {
        Util.spawnItem(this.field_145850_b, this.field_174879_c.func_177984_a(), new ItemStack((Item)gwheel), new double[0]);
        this.field_145850_b.func_175656_a(this.field_174879_c, Main.precision_grinder_empty.func_176223_P().func_177226_a(BlockPrecisionGrinderEmpty.FACING, (Comparable)facing));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cooldown", this.cooldown);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooldown = compound.func_74762_e("cooldown");
    }
}

