/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.Main;

public class TilePickerHolder
extends TileEntity {
    public static final int nSlots = 8;
    public ItemStackHandler inventory = new ItemStackHandler(8);

    public ItemStack swap(ItemStack stack) {
        this.insert(stack);
        int next = this.stackToInt(stack) + 1;
        if (next >= 8) {
            next = 0;
        }
        return this.takeNext(next);
    }

    public ItemStack takeNext(int startI) {
        for (int i = 0; i <= 8; ++i) {
            int takeI = startI + i;
            if (takeI >= 8) {
                takeI -= 8;
            }
            if (this.inventory.getStackInSlot(takeI).func_190926_b()) continue;
            return this.inventory.extractItem(takeI, 1, false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean canInsert(ItemStack picker) {
        return this.inventory.getStackInSlot(this.stackToInt(picker)).func_190926_b();
    }

    public void insert(ItemStack picker) {
        this.inventory.setStackInSlot(this.stackToInt(picker), picker);
    }

    public boolean isEmpty() {
        for (int i = 0; i < 8; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private int stackToInt(ItemStack stack) {
        Item picker = stack.func_77973_b();
        if (picker.equals(Main.myst_dust_picker_c)) {
            return 0;
        }
        if (picker.equals(Main.myst_dust_picker_au)) {
            return 1;
        }
        if (picker.equals(Main.myst_dust_picker_ca)) {
            return 2;
        }
        if (picker.equals(Main.myst_dust_picker_h)) {
            return 3;
        }
        if (picker.equals(Main.myst_dust_picker_fe)) {
            return 4;
        }
        if (picker.equals(Main.myst_dust_picker_n)) {
            return 5;
        }
        if (picker.equals(Main.myst_dust_picker_o)) {
            return 6;
        }
        if (picker.equals(Main.myst_dust_picker_p)) {
            return 7;
        }
        throw new RuntimeException("not a valid dustpicker: " + picker);
    }

    private ItemStack intToStack(int index) {
        Item shard = Main.shards[index];
        if (shard == Main.shard_c) {
            return new ItemStack(Main.myst_dust_picker_c);
        }
        if (shard == Main.shard_au) {
            return new ItemStack(Main.myst_dust_picker_au);
        }
        if (shard == Main.shard_ca) {
            return new ItemStack(Main.myst_dust_picker_ca);
        }
        if (shard == Main.shard_h) {
            return new ItemStack(Main.myst_dust_picker_h);
        }
        if (shard == Main.shard_fe) {
            return new ItemStack(Main.myst_dust_picker_fe);
        }
        if (shard == Main.shard_n) {
            return new ItemStack(Main.myst_dust_picker_n);
        }
        if (shard == Main.shard_o) {
            return new ItemStack(Main.myst_dust_picker_o);
        }
        if (shard == Main.shard_p) {
            return new ItemStack(Main.myst_dust_picker_p);
        }
        throw new RuntimeException("invalid picker index: " + index);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, Main.picker_holder, 0, 0);
        super.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

