/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import wolforce.Hwell;
import wolforce.Util;
import wolforce.blocks.BlockGritVase;
import wolforce.blocks.BlockTray;

public class TileGritVase
extends TileEntity
implements ITickable {
    private BlockPos current = null;
    private Vec3d dir = null;
    private int completeness = 0;

    public void func_73660_a() {
        if (this.current != null && this.field_145850_b.func_175623_d(this.current)) {
            this.reset();
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.current == null) {
                return;
            }
            if (this.dir == null) {
                this.calcDir();
            }
            Hwell.proxy.particle(this.field_145850_b, this.current, this.current, this.dir);
            return;
        }
        if (this.current != null) {
            ++this.completeness;
            if (this.completeness >= 25) {
                IBlockState iblockstate = this.field_145850_b.func_180495_p(this.current);
                Block block = iblockstate.func_177230_c();
                List drops = iblockstate.func_177230_c().getDrops((IBlockAccess)this.field_145850_b, this.field_174879_c, iblockstate, 0);
                for (ItemStack itemStack : drops) {
                    Util.spawnItem(this.field_145850_b, this.field_174879_c.func_177977_b(), itemStack, 0.0, 0.0, 0.0);
                }
                this.field_145850_b.func_180501_a(this.current, Blocks.field_150350_a.func_176223_P(), 3);
                this.reset();
            }
        } else if (Util.timeConstraint(this.field_145850_b.func_82737_E(), 1)) {
            this.search((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGritVase.SIZE));
        }
    }

    private void search(int size) {
        HashSet<Item> filter = new HashSet<Item>();
        boolean isBlackList = BlockTray.getFilter(this.field_145850_b, this.field_174879_c, filter);
        for (int x = -size; x <= size; ++x) {
            for (int y = 1; y <= size * 2; ++y) {
                for (int z = -size; z <= size; ++z) {
                    BlockPos temp = this.field_174879_c.func_177982_a(x, y, z);
                    if (this.field_145850_b.func_175623_d(temp) || !BlockTray.isItemAble(filter, new ItemStack(this.field_145850_b.func_180495_p(temp).func_177230_c()).func_77973_b(), isBlackList)) continue;
                    this.current = temp;
                    this.calcDir();
                    this.func_70296_d();
                    return;
                }
            }
        }
    }

    private void reset() {
        this.completeness = 0;
        this.dir = null;
        this.current = null;
        this.func_70296_d();
    }

    private void calcDir() {
        this.dir = new Vec3d((Vec3i)this.current).func_178788_d(new Vec3d((Vec3i)this.field_174879_c)).func_72432_b();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 3.0, 0.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.current != null) {
            tag.func_74768_a("currx", this.current.func_177958_n());
            tag.func_74768_a("curry", this.current.func_177956_o());
            tag.func_74768_a("currz", this.current.func_177952_p());
            tag.func_74768_a("compl", this.completeness);
        }
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("currx")) {
            this.current = new BlockPos(tag.func_74762_e("currx"), tag.func_74762_e("curry"), tag.func_74762_e("currz"));
            this.completeness = tag.func_74762_e("compl");
        }
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        super.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

