/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.Hwell;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCore;
import wolforce.blocks.BlockGraftingTray;
import wolforce.blocks.tile.TileBranch;
import wolforce.items.ItemBranch;

public class TileGraftingTray
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(1);
    private int charge = 0;

    public void func_73660_a() {
        if (!Util.isValid(this.inventory.getStackInSlot(0)) || !BlockCore.isCore(this.inventory.getStackInSlot(0))) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state == null || state.func_177230_c() != Main.grafting_tray || !((Boolean)state.func_177229_b((IProperty)BlockGraftingTray.FILLED)).booleanValue()) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos2 = this.field_174879_c.func_177982_a(x, 0, z);
                TileEntity tile = this.field_145850_b.func_175625_s(pos2);
                if (tile == null || !(tile instanceof TileBranch)) continue;
                TileBranch btile = (TileBranch)tile;
                long life = ItemBranch.getLife(btile.time);
                if (life <= 0L) continue;
                if (!this.field_145850_b.field_72995_K) {
                    btile.decreaseTime(1000);
                    ++this.charge;
                    continue;
                }
                Vec3d dir = new Vec3d((Vec3i)pos2).func_178788_d(new Vec3d((Vec3i)this.field_174879_c)).func_72432_b();
                this.particles(pos2, dir);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.charge >= Main.graft_costs.get(BlockCore.getCore(this.inventory.getStackInSlot(0)))) {
            this.inventory.setStackInSlot(0, new ItemStack(BlockCore.getGraft(Block.func_149634_a((Item)this.inventory.getStackInSlot(0).func_77973_b())), 8));
            this.charge = 0;
            BlockGraftingTray.changeFilled(this.field_145850_b, this.field_174879_c, false);
            this.func_70296_d();
        }
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(0);
    }

    public ItemStack pop() {
        return this.inventory.extractItem(0, 64, false);
    }

    public void setCoreStack(ItemStack stack) {
        this.inventory.insertItem(0, new ItemStack(stack.func_77973_b(), 1), false);
    }

    private void particles(BlockPos pos2, Vec3d dir) {
        Hwell.proxy.particle(this.field_145850_b, this.field_174879_c, pos2, dir);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("charge", this.charge);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.charge = compound.func_74762_e("charge");
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        super.func_70296_d();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

