/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCore;
import wolforce.recipes.Irio;
import wolforce.recipes.RecipeCoring;

public class TileCore
extends TileEntity
implements ITickable {
    private static final int MAX_CHARGE = 500;
    int charge;

    public void func_73660_a() {
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(block.func_177230_c() instanceof BlockCore)) {
            System.out.println("ERROR! core tile entity is not on a core block");
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Block coreBlock = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        BlockCore.CoreType coreType = (BlockCore.CoreType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCore.SHARD));
        if (coreType == BlockCore.CoreType.core_base) {
            return;
        }
        RecipeCoring result = RecipeCoring.getResult(coreBlock, coreType.getShard());
        if (result == null) {
            return;
        }
        for (BlockPos pos1 : Util.getBlocksTouching(this.field_145850_b, this.field_174879_c)) {
            IBlockState state = this.field_145850_b.func_180495_p(pos1);
            if (!this.hasResult(result, state)) continue;
            this.particles(pos1);
            if (Math.random() < 0.03 && this.isToDrop(pos1)) {
                ItemStack drop = this.getSilkTouchDrop(this.field_145850_b.func_180495_p(pos1));
                this.field_145850_b.func_184138_a(pos1, state, Blocks.field_150350_a.func_176223_P(), 3);
                this.field_145850_b.func_175698_g(pos1);
                Util.spawnItem(this.field_145850_b, pos1, drop, new double[0]);
            }
            if (this.charge >= (int)(499.0f * this.getStabReduction(pos1))) {
                IBlockState newBlock = new Irio(result.result).getState();
                this.changeGrafts(this.field_145850_b, this.field_174879_c, BlockCore.getGraft(coreBlock), newBlock);
                this.field_145850_b.func_180501_a(this.field_174879_c, newBlock, 6);
                return;
            }
            ++this.charge;
            this.func_70296_d();
        }
    }

    private void changeGrafts(World world, BlockPos pos, Block core, IBlockState newBlock) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos pos2 = pos.func_177972_a(facing);
            if (world.func_180495_p(pos2).func_177230_c() != core) continue;
            world.func_175656_a(pos2, newBlock);
            this.changeGrafts(world, pos2, core, newBlock);
        }
    }

    private boolean isToDrop(BlockPos pos1) {
        Block under = this.field_145850_b.func_180495_p(pos1.func_177977_b()).func_177230_c();
        if (under.equals(Main.stabiliser_heavy)) {
            return false;
        }
        if (under.equals(Main.stabiliser)) {
            return Math.random() < 0.25;
        }
        if (under.equals(Main.stabiliser_light)) {
            return Math.random() < 0.5;
        }
        return true;
    }

    private float getStabReduction(BlockPos pos1) {
        Block under = this.field_145850_b.func_180495_p(pos1.func_177977_b()).func_177230_c();
        if (under.equals(Main.stabiliser_light)) {
            return 0.75f;
        }
        if (under.equals(Main.stabiliser)) {
            return 0.625f;
        }
        if (under.equals(Main.stabiliser_heavy)) {
            return 0.5f;
        }
        return 1.0f;
    }

    private boolean hasResult(RecipeCoring result, IBlockState state) {
        if (Arrays.asList(result.consumes).contains(new Irio(state.func_177230_c()))) {
            return true;
        }
        return Arrays.asList(result.consumes).contains(new Irio(state));
    }

    private void particles(BlockPos pos) {
        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.ENCHANTMENT_TABLE, false, (double)pos.func_177958_n() + Math.random(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + Math.random(), 1, 0.0, -0.2, 0.0, 0.01 * Math.random(), new int[0]);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("charge", this.charge);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.charge = compound.func_74762_e("charge");
    }

    protected ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_180651_a(state);
        }
        return new ItemStack(item, 1, i);
    }
}

