/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks.tile;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCharger;
import wolforce.items.ItemPowerCrystal;
import wolforce.recipes.RecipeCharger;

public class TileCharger
extends TileEntity
implements ITickable {
    static final String[][][] multiblock = new String[][][]{{{"CY", "ON", "ON", "ON", "CY"}, {"ON", "MO", "MO", "MO", "ON"}, {"ON", "MO", "MO", "MO", "ON"}, {"ON", "MO", "MO", "MO", "ON"}, {"CY", "ON", "ON", "ON", "CY"}}, {{null, null, null, null, null}, {null, "AR", "AR", "AR", null}, {null, "AR", "AR", "AR", null}, {null, "AR", "AR", "AR", null}, {null, null, null, null, null}}, {{null, null, null, null, null}, {null, null, "GV", null, null}, {null, "GV", "00", "GV", null}, {null, null, "GV", null, null}, {null, null, null, null, null}}};
    private int cooldown = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1);

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.isPowered()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (!Util.isValid(this.inventory.getStackInSlot(0))) {
            return;
        }
        IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(block.func_177230_c() instanceof BlockCharger)) {
            return;
        }
        ItemStack powerCrystal = this.inventory.getStackInSlot(0);
        if (powerCrystal != null) {
            HashMap<String, Util.BlockWithMeta> table = new HashMap<String, Util.BlockWithMeta>();
            table.put("ON", new Util.BlockWithMeta(Main.smooth_onyx));
            table.put("MO", new Util.BlockWithMeta(Main.moonstone));
            table.put("CY", new Util.BlockWithMeta(Main.crystal_block));
            table.put("GV", new Util.BlockWithMeta(Main.gravity_block_mini));
            table.put("AR", new Util.BlockWithMeta(Blocks.field_150350_a));
            List entities = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177977_b()));
            if (!entities.isEmpty() && Util.isMultiblockBuilt(this.field_145850_b, this.field_174879_c, EnumFacing.NORTH, multiblock, table)) {
                for (EntityItem entityItem : entities) {
                    int powerGained = this.tryConsume(powerCrystal, entityItem.func_92059_d());
                    if (powerGained <= 0) continue;
                    this.cooldown = HwellConfig.machines.chargerCooldown;
                    return;
                }
            }
        }
    }

    private boolean isPowered() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.field_145850_b.func_175640_z(this.field_174879_c.func_177972_a(facing))) continue;
            return true;
        }
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    private int tryConsume(ItemStack powerCrystal, ItemStack stack) {
        int powerGained = RecipeCharger.getResult(stack);
        ItemStack result = RecipeCharger.getSpit(stack);
        if (powerGained > 0) {
            ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FLAME, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 10, 0.0, 0.0, 0.0, 0.01 * Math.random(), new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() * 0.2, Math.random() * 0.2, Math.random() * 0.2, Math.random(), new int[0]);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (Util.isValid(result)) {
                Util.spawnItem(this.field_145850_b, this.field_174879_c.func_177984_a(), result, 0.0, 0.5, 0.0);
            }
            stack.func_190917_f(-1);
            if (powerCrystal.func_77978_p() != null && powerCrystal.func_77978_p().func_74764_b("hwell")) {
                NBTTagCompound hwellnbt = powerCrystal.func_77978_p().func_74775_l("hwell");
                int power = ItemPowerCrystal.getPower(hwellnbt);
                int maxPower = ItemPowerCrystal.getMaxPower(hwellnbt);
                int finalPower = Math.min(power + powerGained, maxPower);
                ItemPowerCrystal.setPower(hwellnbt, finalPower);
            }
        }
        return powerGained;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cooldown = compound.func_74762_e("cooldown");
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(facing == EnumFacing.UP && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public void func_70296_d() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        super.func_70296_d();
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

