/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.UtilClient;
import wolforce.recipes.RecipeTube;

public class BlockTube
extends BlockRotatedPillar {
    public BlockTube(String name) {
        super(Material.field_151576_e);
        Util.setReg((Block)this, name);
        this.func_149711_c(1.8f);
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos _pos, Random rand) {
        if (state.func_177229_b((IProperty)field_176298_M) != EnumFacing.Axis.Y || !UtilClient.clientIsDaytime(world)) {
            return;
        }
        BlockPos bot = this.getBlockUnderTube(world, _pos);
        int nTubes = this.getNrOfTubesOnTop(world, bot);
        if (!this.isPossible(nTubes, world, bot)) {
            return;
        }
        if (RecipeTube.getResult(world.func_180495_p(bot)) != null) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)_pos.func_177958_n() + Math.random(), (double)_pos.func_177956_o() + Math.random(), (double)_pos.func_177952_p() + Math.random(), 0.0, -0.02 - Math.random() * 0.2, 0.0, new int[0]);
        }
    }

    public void func_180645_a(World world, BlockPos _pos, IBlockState state, Random random) {
        Block resultBlock;
        if (state.func_177229_b((IProperty)field_176298_M) != EnumFacing.Axis.Y) {
            return;
        }
        BlockPos bot = this.getBlockUnderTube(world, _pos);
        Object result = RecipeTube.getResult(world.func_180495_p(bot));
        if (result instanceof ItemStack) {
            resultBlock = Block.func_149634_a((Item)((ItemStack)result).func_77973_b());
            this.tryMake(world, bot, resultBlock.func_176223_P());
        }
        if (result instanceof FluidStack) {
            resultBlock = ((FluidStack)result).getFluid().getBlock();
            this.tryMake(world, bot, resultBlock.func_176223_P());
        }
    }

    private BlockPos getBlockUnderTube(World world, BlockPos _pos) {
        BlockPos pos = _pos;
        while (world.func_180495_p(pos).func_177230_c() instanceof BlockTube) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    private void tryMake(World world, BlockPos pos, IBlockState state) {
        int nTubes = this.getNrOfTubesOnTop(world, pos);
        if (this.isPossible(nTubes, world, pos) && Math.random() < 0.2 + (double)nTubes * 0.1) {
            world.func_175656_a(pos, state);
            world.func_180497_b(pos, state.func_177230_c(), 0, 0);
        }
    }

    private boolean isPossible(int nTubes, World world, BlockPos pos) {
        return !(nTubes <= 0 || nTubes > 8 || !world.func_175710_j(pos.func_177981_b(nTubes)) && HwellConfig.other.tubeIsRequiredToSeeSky || !this.isDay(world) && HwellConfig.other.tubeIsRequiredToBeDay);
    }

    private boolean isDay(World world) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return UtilClient.clientIsDaytime(world);
        }
        return world.func_72935_r();
    }

    private int getNrOfTubesOnTop(World world, BlockPos pos) {
        int n = 0;
        BlockPos currentPos = pos.func_177984_a();
        while (world.func_180495_p(currentPos).func_177230_c() == Main.furnace_tube && world.func_180495_p(currentPos).func_177229_b((IProperty)field_176298_M) == EnumFacing.Axis.Y && n < 10) {
            ++n;
            currentPos = currentPos.func_177984_a();
        }
        return n;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (this == Main.crystal_block) {
            if (blockState != iblockstate) {
                return true;
            }
            if (block == this) {
                return false;
            }
        }
        return block == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (meta & 0xC) {
            case 0: {
                state = state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y);
                break;
            }
            case 4: {
                state = state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.X);
                break;
            }
            case 8: {
                state = state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Z);
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            case X: {
                return 4;
            }
            case Y: {
                return 0;
            }
            case Z: {
                return 8;
            }
        }
        return 12;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176298_M});
    }
}

