/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.Util;
import wolforce.base.BlockWithDescription;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TileTray;

public class BlockTray
extends Block
implements HasTE,
BlockWithDescription {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public static final PropertyBool ISBLACK = PropertyBool.func_177716_a((String)"isblack");

    public BlockTray(String name) {
        super(Material.field_151575_d);
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ISBLACK, (Comparable)Boolean.valueOf(false)).func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int dy;
        int dx;
        if (player.func_70093_af()) {
            return false;
        }
        if (side != world.func_180495_p(pos).func_177229_b(FACING)) {
            this.changeIsBlack(world, pos);
            return true;
        }
        TileTray tile = (TileTray)world.func_175625_s(pos);
        int n = (double)hitX < 0.333 ? 0 : (dx = (double)hitX < 0.666 ? 1 : 2);
        int n2 = (double)hitY < 0.333 ? 0 : (dy = (double)hitY < 0.666 ? 1 : 2);
        int dz = (double)hitZ < 0.333 ? 0 : ((double)hitZ < 0.666 ? 1 : 2);
        int index = dx + 3 * dz;
        if (side == EnumFacing.NORTH) {
            index = dx + 3 * dy;
        }
        if (side == EnumFacing.SOUTH) {
            index = dx + 3 * dy;
        }
        if (side == EnumFacing.WEST) {
            index = dz + 3 * dy;
        }
        if (side == EnumFacing.EAST) {
            index = dz + 3 * dy;
        }
        if (index < 0 || index > 8) {
            return false;
        }
        ItemStack stack = tile.inventory.getStackInSlot(index);
        if (Util.isValid(stack)) {
            if (!world.field_72995_K) {
                Util.spawnItem(world, pos, tile.inventory.extractItem(index, 64, false), new double[0]);
                tile.func_70296_d();
            }
            return true;
        }
        ItemStack stackToInsert = player.func_184586_b(hand).func_77946_l();
        stackToInsert.func_190920_e(1);
        player.func_184586_b(hand).func_190918_g(1);
        if (!Util.isValid(stackToInsert)) {
            this.changeIsBlack(world, pos);
            return true;
        }
        if (!world.field_72995_K) {
            tile.inventory.setStackInSlot(index, stackToInsert);
            tile.func_70296_d();
        }
        return true;
    }

    private void changeIsBlack(World world, BlockPos pos) {
        ItemStackHandler oldInv = ((TileTray)world.func_175625_s((BlockPos)pos)).inventory;
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b(FACING);
        boolean isblack = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISBLACK);
        IBlockState newstate = world.func_180495_p(pos).func_177226_a((IProperty)ISBLACK, (Comparable)Boolean.valueOf(!isblack)).func_177226_a(FACING, (Comparable)facing);
        world.func_175656_a(pos, newstate);
        ((TileTray)world.func_175625_s((BlockPos)pos)).inventory = oldInv;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            TileTray tile = (TileTray)worldIn.func_175625_s(pos);
            for (int i = 0; i < tile.inventory.getSlots(); ++i) {
                Util.spawnItem(worldIn, pos, tile.inventory.extractItem(i, 64, false), new double[0]);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public static boolean getFilter(World world, BlockPos pos, HashSet<Item> filters) {
        BlockPos pos2;
        boolean isBlackList = true;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            pos2 = pos.func_177972_a(face);
            if (!(world.func_180495_p(pos2).func_177230_c() instanceof BlockTray) || BlockTray.isBlackList(world, pos2)) continue;
            isBlackList = false;
            break;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            pos2 = pos.func_177972_a(face);
            if (!(world.func_180495_p(pos2).func_177230_c() instanceof BlockTray) || BlockTray.isBlackList(world, pos2) != isBlackList) continue;
            ItemStackHandler inv = ((TileTray)world.func_175625_s((BlockPos)pos2)).inventory;
            for (int i = 0; i < 9; ++i) {
                ItemStack slot = inv.getStackInSlot(i);
                if (!Util.isValid(slot)) continue;
                filters.add(slot.func_77973_b());
            }
        }
        return isBlackList;
    }

    private static boolean isBlackList(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISBLACK);
    }

    public static boolean isItemAble(HashSet<Item> filter, Item item, boolean isBlackList) {
        return filter.isEmpty() || isBlackList != filter.contains(item);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b(FACING)) {
            case DOWN: {
                return AABB_DOWN;
            }
            case EAST: {
                return AABB_EAST;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case UP: {
                return AABB_UP;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        return AABB_DOWN;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b(FACING)) {
            case DOWN: {
                return AABB_DOWN;
            }
            case EAST: {
                return AABB_EAST;
            }
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case UP: {
                return AABB_UP;
            }
            case WEST: {
                return AABB_WEST;
            }
        }
        return AABB_DOWN;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.field_70125_A < -45.0f) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.DOWN);
        }
        if (placer.field_70125_A > 45.0f) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP);
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ISBLACK});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.values()[meta & 7]).func_177226_a((IProperty)ISBLACK, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b(FACING)).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)ISBLACK)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTray();
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Small Item Tray that holds up to 9 Items.", "Also serves as a white list filter to gravity and setter blocks.", "Will change to a black filter when right clicked with an empty hand."};
    }
}

