/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TileSetter;

public class BlockSetter
extends Block
implements HasTE,
BlockEnergyConsumer {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockSetter(String name) {
        super(Material.field_151573_f);
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer.field_70125_A < -45.0f) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.DOWN);
        }
        if (placer.field_70125_A > 45.0f) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP);
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos _pos, Random rand) {
        int start;
        if (worldIn.func_175640_z(_pos)) {
            return;
        }
        EnumFacing facing = (EnumFacing)stateIn.func_177229_b(FACING);
        int extraRange = BlockSetter.getExtraRange(worldIn, _pos, facing);
        for (int i = start = BlockSetter.getStart(worldIn, _pos, facing); i < start + HwellConfig.machines.setterBaseRange + extraRange; ++i) {
            BlockPos pos = _pos.func_177967_a(facing, i);
            worldIn.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, -0.02 - Math.random() * 0.2, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, -0.02 - Math.random() * 0.2, 0.0, new int[0]);
        }
    }

    public static int getStart(World worldIn, BlockPos _pos, EnumFacing facing) {
        int start = 1;
        for (EnumFacing f : EnumFacing.values()) {
            if (f == facing || !worldIn.func_180495_p(_pos.func_177972_a(f)).func_177230_c().equals(Main.crystal_block)) continue;
            ++start;
        }
        return start;
    }

    public static int getExtraRange(World worldIn, BlockPos _pos, EnumFacing facing) {
        BlockPos pos = _pos.func_177972_a(facing);
        int range = 0;
        for (EnumFacing f : EnumFacing.values()) {
            if (f == facing) continue;
            Block block = worldIn.func_180495_p(_pos.func_177972_a(f)).func_177230_c();
            if (block.equals((Object)Main.moonstone)) {
                ++range;
            }
            if (!block.equals((Object)Main.azurite) && !block.equals((Object)Main.smooth_azurite)) continue;
            --range;
        }
        return Math.max(range, -HwellConfig.machines.setterBaseRange + 1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).ordinal();
    }

    @Override
    public int getEnergyConsumption() {
        return HwellConfig.machines.setterConsumption;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Consumes 5 Energy per Operation."};
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSetter();
    }
}

