/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.HwellConfig;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TileSeparator;

public class BlockSeparator
extends Block
implements BlockEnergyConsumer,
HasTE {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);

    public BlockSeparator(String name) {
        super(Material.field_151576_e);
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileSeparator tile = (TileSeparator)world.func_175625_s(pos);
            ItemStackHandler itemHandler = tile.inventory;
            ItemStack held = player.func_184586_b(hand);
            if (!player.func_70093_af()) {
                if (itemHandler.getStackInSlot(0).equals(ItemStack.field_190927_a)) {
                    if (!held.func_190926_b()) {
                        itemHandler.insertItem(0, held.func_77946_l(), false);
                        held.func_190920_e(0);
                        tile.func_70296_d();
                    }
                } else {
                    ItemStack itemToTake = itemHandler.extractItem(0, 64, false);
                    tile.func_70296_d();
                    if (held.func_190926_b()) {
                        player.func_184611_a(hand, itemToTake);
                    } else if (held.func_77973_b().equals(itemToTake.func_77973_b()) && held.func_77960_j() == itemToTake.func_77960_j() && held.func_190916_E() < held.func_77973_b().getItemStackLimit(held)) {
                        held.func_190917_f(1);
                    } else {
                        Util.spawnItem(world, pos, itemToTake, new double[0]);
                    }
                }
            }
            tile.func_70296_d();
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileSeparator tile = (TileSeparator)world.func_175625_s(pos);
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        ItemStack item = itemHandler.getStackInSlot(0);
        if (!item.func_190926_b()) {
            Util.spawnItem(world, pos, item, new double[0]);
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return aabb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSeparator();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).ordinal();
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Separates items into its components.", "Consumes " + this.getEnergyConsumption() + " energy per operation.", "Requires a multiblock Structure."};
    }

    @Override
    public int getEnergyConsumption() {
        return HwellConfig.machines.separatorConsumption;
    }
}

