/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockEnergyConsumer;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TilePrecisionGrinder;
import wolforce.items.ItemGrindingWheel;

public class BlockPrecisionGrinder
extends Block
implements HasTE,
BlockEnergyConsumer {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    public ItemGrindingWheel grindingWheel;

    public BlockPrecisionGrinder(String name, ItemGrindingWheel grindingWheel) {
        super(Material.field_151573_f);
        this.grindingWheel = grindingWheel;
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Item)this.grindingWheel));
        drops.add((Object)new ItemStack(Main.precision_grinder_empty));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing prevfacing = (EnumFacing)world.func_180495_p(pos).func_177229_b(FACING);
        Item held = player.func_184586_b(hand).func_77973_b();
        IBlockState nextState = Main.precision_grinder_empty.func_176223_P();
        if (held instanceof ItemGrindingWheel) {
            if (held == Main.grinding_wheel_crystal) {
                nextState = Main.precision_grinder_crystal.func_176223_P();
            }
            if (held == Main.grinding_wheel_iron) {
                nextState = Main.precision_grinder_iron.func_176223_P();
            }
            if (held == Main.grinding_wheel_diamond) {
                nextState = Main.precision_grinder_diamond.func_176223_P();
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        world.func_175656_a(pos, nextState.func_177226_a(FACING, (Comparable)prevfacing));
        if (!world.field_72995_K) {
            Util.spawnItem(world, pos.func_177972_a(facing), new ItemStack((Item)this.grindingWheel), new double[0]);
        }
        return true;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return aabb;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return aabb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePrecisionGrinder();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).ordinal();
    }

    @Override
    public int getEnergyConsumption() {
        return HwellConfig.machines.grinderConsumption;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Consumes " + this.getEnergyConsumption() + " energy per operation."};
    }
}

