/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TilePickingTable;
import wolforce.items.tools.ItemDustPicker;

public class BlockPickingTable
extends Block
implements HasTE {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB aabb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375);
    public static final PropertyInteger FILLING = PropertyInteger.func_177719_a((String)"filling", (int)0, (int)3);

    public BlockPickingTable(String name) {
        super(Material.field_151575_d);
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", -1);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand enumhand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack hand = playerIn.func_184586_b(enumhand);
        if ((Integer)state.func_177229_b((IProperty)FILLING) == 0) {
            if (hand.func_77973_b() == Main.myst_dust) {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(3)));
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(enumhand).func_190918_g(1);
                }
                return true;
            }
        } else if (hand.func_77973_b() instanceof ItemDustPicker) {
            if ((Integer)state.func_177229_b((IProperty)FILLING) == 0) {
                return false;
            }
            if (!world.field_72995_K && Math.random() < HwellConfig.other.pickingTableChance) {
                Util.spawnItem(world, pos, new ItemStack(((ItemDustPicker)hand.func_77973_b()).shard, 1), new double[0]);
            }
            IBlockState newstate = BlockPickingTable.reduce(state);
            world.func_175656_a(pos, newstate);
            hand.func_77972_a(1, (EntityLivingBase)playerIn);
            return true;
        }
        return false;
    }

    public static IBlockState reduce(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)FILLING) == 3) {
            return state.func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(2));
        }
        if ((Integer)state.func_177229_b((IProperty)FILLING) == 2) {
            return state.func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(1));
        }
        if ((Integer)state.func_177229_b((IProperty)FILLING) == 1) {
            return state.func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public static IBlockState increase(IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)FILLING) == 0) {
            return state.func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(3));
        }
        return state;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return aabb;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return aabb;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILLING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FILLING, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)FILLING);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePickingTable();
    }
}

