/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wolforce.Util;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TilePickerHolder;
import wolforce.items.tools.ItemDustPicker;

public class BlockPickerHolder
extends Block
implements HasTE {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockPickerHolder(String name) {
        super(Material.field_151575_d);
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || hand != EnumHand.MAIN_HAND) {
            return false;
        }
        TilePickerHolder tile = (TilePickerHolder)world.func_175625_s(pos);
        ItemStack stackHeld = player.func_184586_b(hand);
        if (!(Util.isValid(stackHeld) || tile.isEmpty() || player.func_70093_af())) {
            player.func_184611_a(hand, tile.takeNext(0));
            tile.func_70296_d();
            return true;
        }
        if (!Util.isValid(stackHeld) || !(stackHeld.func_77973_b() instanceof ItemDustPicker)) {
            return false;
        }
        if (player.func_70093_af()) {
            if (tile.canInsert(stackHeld)) {
                tile.insert(stackHeld);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                tile.func_70296_d();
                return true;
            }
        } else if (tile.canInsert(stackHeld) && !tile.isEmpty()) {
            player.func_184611_a(hand, tile.swap(stackHeld));
            tile.func_70296_d();
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = ((TilePickerHolder)world.func_175625_s((BlockPos)pos)).inventory.extractItem(i, 1, false);
            Util.spawnItem(world, pos, stack, new double[0]);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return aabb;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return aabb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePickerHolder();
    }
}

