/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemStackHandler;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockWithDescription;
import wolforce.base.HasTE;
import wolforce.base.MyBlock;
import wolforce.blocks.BlockCore;
import wolforce.blocks.tile.TileGraftingTray;

public class BlockGraftingTray
extends MyBlock
implements HasTE,
BlockWithDescription {
    private static final double F = 0.0625;
    protected static final AxisAlignedBB colbox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");

    public BlockGraftingTray(String name) {
        super(name, Material.field_151576_e);
        this.setHardness(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack handstack = playerIn.func_184586_b(hand);
        if (handstack.func_77973_b() == Items.field_151133_ar || handstack.func_77973_b() == ForgeModContainer.getInstance().universalBucket) {
            ItemStack bucket_filled = FluidUtil.getFilledBucket((FluidStack)new FluidStack(Main.liquid_souls, 1000));
            ItemStack bucket_empty = new ItemStack(Items.field_151133_ar);
            if (!((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue() && Util.equalNBT(handstack, bucket_filled)) {
                if (!world.field_72995_K) {
                    BlockGraftingTray.changeFilled(world, pos, true);
                }
                playerIn.func_184611_a(hand, bucket_empty);
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)FILLED)).booleanValue() && Util.equalNBT(handstack, bucket_empty)) {
                if (!world.field_72995_K) {
                    BlockGraftingTray.changeFilled(world, pos, false);
                }
                playerIn.func_184611_a(hand, bucket_filled);
                return true;
            }
            return false;
        }
        TileGraftingTray tile = (TileGraftingTray)world.func_175625_s(pos);
        if (!Util.isValid(tile.getStack()) && BlockCore.isCore(handstack)) {
            if (!world.field_72995_K) {
                tile.setCoreStack(handstack);
                tile.func_70296_d();
            }
            handstack.func_190918_g(1);
            return true;
        }
        if (!world.field_72995_K) {
            ItemStack pop = tile.pop();
            Util.spawnItem(world, pos, pop, new double[0]);
            tile.func_70296_d();
        }
        return true;
    }

    public static void changeFilled(World world, BlockPos pos, boolean filled) {
        ItemStackHandler oldInv = ((TileGraftingTray)world.func_175625_s((BlockPos)pos)).inventory;
        world.func_175656_a(pos, Main.grafting_tray.func_176223_P().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(filled)));
        ((TileGraftingTray)world.func_175625_s((BlockPos)pos)).inventory = oldInv;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileGraftingTray) {
            drops.add((Object)((TileGraftingTray)te).inventory.getStackInSlot(0));
        }
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return colbox;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return colbox;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILLED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FILLED) != false ? 1 : 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGraftingTray();
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Allows the production of Core Grafts. Fill with water and a core, then place Living Branches around it."};
    }
}

