/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wolforce.Util;

public class BlockGaseousFrame
extends Block {
    static final AxisAlignedBB BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyBool PASSABLE = PropertyBool.func_177716_a((String)"passable");

    public BlockGaseousFrame(String name) {
        super(Material.field_151592_s);
        Util.setReg(this, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PASSABLE, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("pickaxe", -1);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            this.transform(worldIn, pos, (Boolean)state.func_177229_b((IProperty)PASSABLE) == false);
        }
        return true;
    }

    private void transform(World world, BlockPos pos, boolean newValue) {
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)PASSABLE, (Comparable)Boolean.valueOf(newValue)));
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState state2 = world.func_180495_p(pos.func_177972_a(facing));
            if (!(state2.func_177230_c() instanceof BlockGaseousFrame) || (Boolean)state2.func_177229_b((IProperty)PASSABLE) == newValue) continue;
            this.transform(world, pos.func_177972_a(facing), newValue);
        }
    }

    private boolean isPassable(IBlockState state) {
        return state.func_177230_c() instanceof BlockGaseousFrame && state.func_177227_a().contains(PASSABLE) && (Boolean)state.func_177229_b((IProperty)PASSABLE) != false;
    }

    public boolean func_176214_u(IBlockState state) {
        return !this.isPassable(state);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return !this.isPassable(state);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return this.isPassable(world.func_180495_p(pos));
    }

    public boolean func_185481_k(IBlockState state) {
        return !this.isPassable(state);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !this.isPassable(state);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149751_l(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.isPassable(state) ? null : BB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PASSABLE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PASSABLE, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PASSABLE) != false ? 1 : 0;
    }
}

