/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.base.BlockEnergyConsumer;
import wolforce.base.BlockMachineBase;
import wolforce.recipes.RecipeFreezer;

public class BlockFreezer
extends BlockMachineBase
implements BlockEnergyConsumer {
    public BlockFreezer(String name) {
        super(name);
        this.func_149675_a(true);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K || world.func_175640_z(pos)) {
            return;
        }
        if (!world.func_72935_r() || !HwellConfig.machines.freezerIsRequiredToBeNight) {
            List<BlockPos> nearBlocks = this.getNearBlocks(world, pos);
            if (nearBlocks.size() == 0) {
                return;
            }
            if (!BlockEnergyConsumer.tryConsume(world, pos, this.getEnergyConsumption())) {
                return;
            }
            int randomIndex = (int)(Math.random() * (double)nearBlocks.size());
            world.func_175656_a(nearBlocks.get(randomIndex), RecipeFreezer.getResult(world, pos, world.func_180495_p(nearBlocks.get(randomIndex))).func_176223_P());
        }
    }

    private List<BlockPos> getNearBlocks(World world, BlockPos pos) {
        LinkedList<BlockPos> list = new LinkedList<BlockPos>();
        int n = HwellConfig.machines.freezerRange;
        for (int x = -n; x <= n; ++x) {
            for (int y = -n; y <= n; ++y) {
                for (int z = -n; z <= n; ++z) {
                    BlockPos thispos = pos.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(thispos);
                    if (!RecipeFreezer.hasResult(world, pos, state)) continue;
                    list.add(thispos);
                }
            }
        }
        return list;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Will freeze nearby water to ice or snow,", "and nearby lava to obsidian.", "Only works at night.", "Consumes " + this.getEnergyConsumption() + " energy per operation."};
    }

    @Override
    public int getEnergyConsumption() {
        return HwellConfig.machines.freezerConsumption;
    }
}

