/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.base.BlockEnergyConsumer;
import wolforce.base.MyBlock;

public class BlockFormer
extends MyBlock
implements BlockEnergyConsumer {
    public BlockFormer(String name) {
        super(name, Material.field_151576_e, true);
        this.setResistance(2.0f);
        this.setHardness(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_180645_a(World world, BlockPos _pos, IBlockState state, Random random) {
        if (world.field_72995_K || world.func_175640_z(_pos)) {
            return;
        }
        if (!BlockEnergyConsumer.tryConsume(world, _pos, this.getEnergyConsumption())) {
            return;
        }
        BlockPos pos = this.getPos(world, _pos);
        if (pos == null) {
            return;
        }
        world.func_184133_a(null, _pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
    }

    private BlockPos getPos(World world, BlockPos pos) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        double d = 1.0;
        double miny = -d / 4.0;
        double temp = miny / d;
        for (int iterations = 0; iterations < 0x3FFFFFFF; ++iterations) {
            for (double x = -d; x < d; x += 1.0) {
                for (double y = -d; y < 0.0; y += 1.0) {
                    for (double z = -d; z < d; z += 1.0) {
                        double d2 = d * d;
                        double y2 = y * temp;
                        double r = x * x + z * z + y * y / 0.2;
                        if (!(r < d2) || !world.func_175623_d(pos.func_177963_a(x, y, z))) continue;
                        blocks.add(pos.func_177963_a(x, y, z));
                    }
                }
            }
            if (!blocks.isEmpty()) {
                return (BlockPos)blocks.get((int)(Math.random() * (double)blocks.size()));
            }
            d += 0.5;
        }
        return null;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Will slowly create a flat-top, circular, stone shape around it.", "Consumes " + this.getEnergyConsumption() + " energy per operation."};
    }

    @Override
    public int getEnergyConsumption() {
        return HwellConfig.machines.formerConsumption;
    }
}

