/*
 * Decompiled with CFR 0.152.
 */
package wolforce.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.HasTE;
import wolforce.blocks.tile.TileCore;
import wolforce.recipes.RecipeCoring;

public class BlockCore
extends Block
implements HasTE {
    public static PropertyEnum SHARD = PropertyEnum.func_177709_a((String)"shard", CoreType.class);
    private boolean isToRegisterTileEntity;
    public int color1;
    public int color2;

    public static boolean isCore(ItemStack stack) {
        ItemStack stack2 = new ItemStack((Block)Main.core_stone);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return true;
        }
        stack2 = new ItemStack((Block)Main.core_anima);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return true;
        }
        stack2 = new ItemStack((Block)Main.core_heat);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return true;
        }
        stack2 = new ItemStack((Block)Main.core_green);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return true;
        }
        stack2 = new ItemStack((Block)Main.core_sentient);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return true;
        }
        for (BlockCore customcore : Main.custom_cores.values()) {
            stack2 = new ItemStack((Block)customcore);
            if (stack.func_77973_b() != stack2.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public static BlockCore getCore(ItemStack stack) {
        if (!Util.isValid(stack)) {
            return null;
        }
        ItemStack stack2 = new ItemStack((Block)Main.core_stone);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return Main.core_stone;
        }
        stack2 = new ItemStack((Block)Main.core_anima);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return Main.core_anima;
        }
        stack2 = new ItemStack((Block)Main.core_heat);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return Main.core_heat;
        }
        stack2 = new ItemStack((Block)Main.core_green);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return Main.core_green;
        }
        stack2 = new ItemStack((Block)Main.core_sentient);
        if (stack.func_77973_b() == stack2.func_77973_b()) {
            return Main.core_sentient;
        }
        for (BlockCore customcore : Main.custom_cores.values()) {
            stack2 = new ItemStack((Block)customcore);
            if (stack.func_77973_b() != stack2.func_77973_b()) continue;
            return customcore;
        }
        return null;
    }

    public static Block getGraft(Block coreBlock) {
        if (coreBlock == Main.core_stone) {
            return Main.graft_stone;
        }
        if (coreBlock == Main.core_anima) {
            return Main.graft_anima;
        }
        if (coreBlock == Main.core_heat) {
            return Main.graft_heat;
        }
        if (coreBlock == Main.core_green) {
            return Main.graft_green;
        }
        if (coreBlock == Main.core_sentient) {
            return Main.graft_sentient;
        }
        if (Main.custom_grafts.containsKey(coreBlock)) {
            return Main.custom_grafts.get(coreBlock);
        }
        return null;
    }

    public BlockCore(String name, boolean isToRegister) {
        this(name, isToRegister, null, null);
    }

    public BlockCore(String name, boolean isToRegisterTileEntity, String colorString1, String colorString2) {
        super(Material.field_151571_B);
        this.isToRegisterTileEntity = isToRegisterTileEntity;
        Util.setReg(this, name);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SHARD, (Comparable)((Object)CoreType.core_base)));
        if (colorString1 != null && colorString2 != null) {
            this.color1 = Integer.parseInt(colorString1, 16);
            this.color2 = Integer.parseInt(colorString2, 16);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand enumhand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177228_b().get((Object)SHARD) != CoreType.core_base) {
            return false;
        }
        Item hand = playerIn.func_184586_b(enumhand).func_77973_b();
        if (RecipeCoring.getResult(this, hand) == null) {
            return false;
        }
        for (CoreType ctype : CoreType.values()) {
            if (!hand.equals(ctype.getShard())) continue;
            this.set(world, pos, ctype);
        }
        if (!playerIn.func_184812_l_()) {
            playerIn.func_184586_b(enumhand).func_190918_g(1);
        }
        return true;
    }

    private void set(World world, BlockPos pos, CoreType coretype) {
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)SHARD, (Comparable)((Object)coretype)));
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCore();
    }

    @Override
    public boolean isToRegisterTileEntity() {
        return this.isToRegisterTileEntity;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHARD});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SHARD, (Comparable)((Object)CoreType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b((IProperty)SHARD))).ordinal();
    }

    public static enum CoreType implements IStringSerializable
    {
        core_base,
        core_c,
        core_ca,
        core_fe,
        core_o,
        core_au,
        core_h,
        core_p,
        core_n;


        public String func_176610_l() {
            return this.name();
        }

        public Item getShard() {
            switch (this) {
                case core_au: {
                    return Main.shard_au;
                }
                case core_c: {
                    return Main.shard_c;
                }
                case core_ca: {
                    return Main.shard_ca;
                }
                case core_fe: {
                    return Main.shard_fe;
                }
                case core_h: {
                    return Main.shard_h;
                }
                case core_n: {
                    return Main.shard_n;
                }
                case core_o: {
                    return Main.shard_o;
                }
                case core_p: {
                    return Main.shard_p;
                }
            }
            return null;
        }
    }
}

