/*
 * Decompiled with CFR 0.152.
 */
package wolforce;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import wolforce.Hwell;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.base.MyBlock;
import wolforce.base.MySlab;
import wolforce.base.MyStairs;
import wolforce.recipes.Irio;

public class Util {
    public static void setReg(Block block, String name) {
        block.func_149663_c("hwell." + name);
        block.setRegistryName(Util.res(name));
    }

    public static void setReg(Item block, String name) {
        block.func_77655_b("hwell." + name);
        block.setRegistryName(Util.res(name));
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_190916_E() > 0 && !stack.func_190926_b() && !stack.func_77973_b().equals(Items.field_190931_a);
    }

    public static boolean canBeStacked(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean equalExceptAmount(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static void spawnItem(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        Util.spawnItem(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), stack, facing);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, EnumFacing facing) {
        Util.spawnItem(world, pos, stack, 0, facing);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, int pickupDelay, EnumFacing facing) {
        Vec3d v = Util.facingToVector(facing);
        Util.spawnItem(world, pos, stack, pickupDelay, v.field_72450_a / 2.0, v.field_72448_b / 2.0, v.field_72449_c / 2.0);
    }

    public static void spawnItem(World world, BlockPos pos, ItemStack stack, double ... speeds) {
        Util.spawnItem(world, new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5), stack, speeds);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, double ... speeds) {
        Util.spawnItem(world, pos, stack, 0, speeds);
    }

    public static void spawnItem(World world, Vec3d pos, ItemStack stack, int pickupDelay, double ... speeds) {
        if (!Util.isValid(stack)) {
            return;
        }
        EntityItem entityitem = new EntityItem(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack);
        if (speeds.length == 0) {
            entityitem.field_70159_w = Math.random() * 0.4 - 0.2;
            entityitem.field_70181_x = Math.random() * 0.2;
            entityitem.field_70179_y = Math.random() * 0.4 - 0.2;
        } else {
            entityitem.field_70159_w = speeds[0];
            entityitem.field_70181_x = speeds[1];
            entityitem.field_70179_y = speeds[2];
        }
        entityitem.func_174867_a(pickupDelay);
        world.func_72838_d((Entity)entityitem);
    }

    public static Vec3d facingToVector(EnumFacing facing) {
        return new Vec3d((double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.X) ? 1 : 0)), (double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.Y) ? 1 : 0)), (double)(facing.func_176743_c().func_179524_a() * (facing.func_176740_k().equals((Object)EnumFacing.Axis.Z) ? 1 : 0)));
    }

    public static LinkedList<Block> makeVariants(MyBlock ... blocks) {
        LinkedList<Block> variants = new LinkedList<Block>();
        for (MyBlock block : blocks) {
            MySlab slab = new MySlab(block);
            variants.add(slab);
            MyStairs stairs = new MyStairs(block);
            variants.add((Block)stairs);
            if (block == Main.myst_planks) continue;
            MyBlock brick = new MyBlock(block.getRegistryName().func_110623_a() + "_bricks", block.func_176223_P().func_185904_a());
            brick.setHardness(block.hardness);
            brick.setResistance(block.resistance);
            variants.add(brick);
            MySlab brickslab = new MySlab(brick);
            brickslab.setHardness(block.hardness);
            brickslab.setResistance(block.resistance);
            variants.add(brickslab);
            MyStairs brickstairs = new MyStairs(brick);
            brickstairs.func_149711_c(block.hardness);
            brickstairs.func_149752_b(block.resistance);
            variants.add((Block)brickstairs);
        }
        return variants;
    }

    public static ResourceLocation res(String string) {
        return new ResourceLocation("hwell", string);
    }

    public static BlockPos[] getBlocksTouching(World world, BlockPos pos) {
        BlockPos[] ret = new BlockPos[EnumFacing.field_82609_l.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = pos.func_177972_a(EnumFacing.field_82609_l[i]);
        }
        return ret;
    }

    public static boolean isMultiblockBuilt(World world, BlockPos realPos, EnumFacing facing, String[][][] multiblock, HashMap<String, BlockWithMeta> table) {
        block7: {
            BlockPos center;
            block6: {
                center = Util.getMyPosition(facing, multiblock);
                if (facing != EnumFacing.EAST && facing != EnumFacing.WEST) break block6;
                for (int y = 0; y < multiblock.length; ++y) {
                    for (int x = 0; x < multiblock[y].length; ++x) {
                        for (int z = 0; z < multiblock[y][x].length; ++z) {
                            if (multiblock[y][x][z] == null || multiblock[y][x][z] == "00" || Util.checkPos(world, realPos, center, facing, multiblock[y][x][z], x, y, z, table)) continue;
                            return false;
                        }
                    }
                }
                break block7;
            }
            if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) break block7;
            for (int y = 0; y < multiblock.length; ++y) {
                for (int z = 0; z < multiblock[y].length; ++z) {
                    for (int x = 0; x < multiblock[y][z].length; ++x) {
                        if (multiblock[y][z][x] == null || multiblock[y][z][x] == "00" || Util.checkPos(world, realPos, center, facing, multiblock[y][z][x], x, y, z, table)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean checkPos(World world, BlockPos realPos, BlockPos centre, EnumFacing facing, String mbs, int x, int y, int z, HashMap<String, BlockWithMeta> table) {
        boolean isCorrect;
        BlockPos thispos = centre.func_177973_b((Vec3i)new BlockPos(x, y, z));
        if (facing == EnumFacing.EAST) {
            thispos = new BlockPos(-thispos.func_177958_n(), thispos.func_177956_o(), thispos.func_177952_p());
        }
        if (facing == EnumFacing.WEST) {
            thispos = new BlockPos(thispos.func_177958_n(), thispos.func_177956_o(), -thispos.func_177952_p());
        }
        if (facing == EnumFacing.SOUTH) {
            thispos = new BlockPos(-thispos.func_177958_n(), thispos.func_177956_o(), -thispos.func_177952_p());
        }
        BlockWithMeta tableEntry = table.get(mbs);
        IBlockState state = world.func_180495_p(realPos.func_177973_b((Vec3i)thispos));
        boolean bl = isCorrect = tableEntry.block == state.func_177230_c() && Util.hasCorrectMeta(tableEntry.block, tableEntry.meta, tableEntry.block.func_176201_c(state), tableEntry.inverse);
        if (!isCorrect && HwellConfig.general.isAutomaticMultiblocks) {
            if (tableEntry.meta != -1) {
                world.func_180501_a(realPos.func_177973_b((Vec3i)thispos), tableEntry.block.func_176203_a(tableEntry.inverse ? (tableEntry.meta != 0 ? 0 : tableEntry.meta) : tableEntry.meta), 2);
            } else {
                world.func_180501_a(realPos.func_177973_b((Vec3i)thispos), tableEntry.block.func_176223_P(), 2);
            }
            return true;
        }
        return isCorrect;
    }

    private static boolean hasCorrectMeta(Block block, int requiredMeta, int meta, boolean inverse) {
        return requiredMeta == -1 || (inverse ? meta != requiredMeta : meta == requiredMeta);
    }

    private static BlockPos getMyPosition(EnumFacing facing, String[][][] multiblock) {
        int y;
        if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            for (y = 0; y < multiblock.length; ++y) {
                for (int x = 0; x < multiblock[y].length; ++x) {
                    for (int z = 0; z < multiblock[y][x].length; ++z) {
                        if (multiblock[y][x][z] != "00") continue;
                        return new BlockPos(x, y, z);
                    }
                }
            }
        }
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            for (y = 0; y < multiblock.length; ++y) {
                for (int z = 0; z < multiblock[y].length; ++z) {
                    for (int x = 0; x < multiblock[y][z].length; ++x) {
                        if (multiblock[y][z][x] != "00") continue;
                        return new BlockPos(x, y, z);
                    }
                }
            }
        }
        return null;
    }

    public static <T> List<T> listOfOne(T item) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(item);
        return list;
    }

    public static List<ItemStack> listOfOneItemStack(Item item) {
        return Util.listOfOne(new ItemStack(item));
    }

    public static List<ItemStack> listOfOneItemStack(Block block) {
        return Util.listOfOne(new ItemStack(block));
    }

    public static Irio toIrio(IBlockState blockState) {
        return new Irio(blockState.func_177230_c(), blockState.func_177230_c().func_176201_c(blockState));
    }

    public static boolean isVanillaFluid(Block in) {
        return in == Blocks.field_150355_j || in == Blocks.field_150358_i || in == Blocks.field_150353_l || in == Blocks.field_150356_k;
    }

    public static FluidStack vanillaFluidBlockToFluidStack(Block in) {
        if (in == Blocks.field_150355_j || in == Blocks.field_150358_i) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (in == Blocks.field_150353_l || in == Blocks.field_150356_k) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    private static <T> String toStringed(Collection<T> inList, ToStringer<T> ... toStringer) {
        String s = "";
        for (T t : inList) {
            if (toStringer.length > 0) {
                s = s + toStringer[0].toString(t) + ", ";
                continue;
            }
            s = s + t.toString() + ", ";
        }
        return s.substring(0, s.length() - 3);
    }

    public static List<ItemStack> toItemStackList(Block[] blocks) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (Block block : blocks) {
            list.add(new ItemStack(block));
        }
        return list;
    }

    public static Item getRegisteredItem(String name) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        if (item == null) {
            throw new IllegalStateException("Invalid Item requested: " + name);
        }
        return item;
    }

    public static Block getRegisteredBlock(String name) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
        if (block == null) {
            throw new IllegalStateException("Invalid Block requested: " + name);
        }
        return block;
    }

    private void makeTree(World world, BlockPos pos) {
        BlockPos dpos;
        IBlockState wood = Blocks.field_150364_r.func_176223_P();
        IBlockState leaf = Blocks.field_150362_t.func_176223_P();
        world.func_175656_a(pos.func_177981_b(0), wood);
        world.func_175656_a(pos.func_177981_b(1), wood);
        world.func_175656_a(pos.func_177981_b(2), wood);
        world.func_175656_a(pos.func_177981_b(3), wood);
        world.func_175656_a(pos.func_177981_b(4), wood);
        for (int[] d : new int[][]{{-2, -2}, {-2, -1}, {-2, 0}, {-2, 1}, {-2, 2}, {-1, -2}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 2}, {0, -2}, {0, -1}, {0, 0}, {0, 1}, {0, 2}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {2, -2}, {2, -1}, {2, 0}, {2, 1}, {2, 2}}) {
            dpos = pos.func_177982_a(d[0], 2, d[1]);
            if (!world.func_175623_d(dpos)) continue;
            world.func_175656_a(dpos, leaf);
        }
        for (int[] d : new int[][]{{-2, -1}, {-2, 0}, {-2, 1}, {-1, -2}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 2}, {0, -2}, {0, -1}, {0, 1}, {0, 2}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {2, -1}, {2, 0}, {2, 1}}) {
            dpos = pos.func_177982_a(d[0], 3, d[1]);
            if (!world.func_175623_d(dpos)) continue;
            world.func_175656_a(dpos, leaf);
        }
        for (int[] d : new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, 0}, {1, 1}}) {
            dpos = pos.func_177982_a(d[0], 4, d[1]);
            if (!world.func_175623_d(dpos)) continue;
            world.func_175656_a(dpos, leaf);
        }
        for (int[] d : new int[][]{{-1, 0}, {0, -1}, {0, 0}, {0, 1}, {1, 0}}) {
            dpos = pos.func_177982_a(d[0], 5, d[1]);
            if (!world.func_175623_d(dpos)) continue;
            world.func_175656_a(dpos, leaf);
        }
    }

    public static Block blockAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static JsonElement readJson(String resource, boolean ... internal) throws IOException {
        Gson gson = new Gson();
        InputStream in = internal.length > 0 && internal[0] ? Hwell.class.getResourceAsStream(resource) : new FileInputStream(new File(resource));
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        return je;
    }

    public static Irio readJsonIrio(JsonObject o) {
        if (!o.has("data")) {
            o.addProperty("data", (Number)0);
            ItemStack input = ShapedRecipes.func_192405_a((JsonObject)o, (boolean)true);
            return new Irio(input.func_77973_b());
        }
        ItemStack input = ShapedRecipes.func_192405_a((JsonObject)o, (boolean)true);
        return new Irio(input.func_77973_b(), input.func_77960_j());
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment ench) {
        if (!stack.func_77948_v()) {
            return false;
        }
        NBTTagList enchs = stack.func_77986_q();
        for (NBTBase nbtBase : enchs) {
            if (((NBTTagCompound)nbtBase).func_74765_d("id") != Enchantment.func_185258_b((Enchantment)ench)) continue;
            return true;
        }
        return false;
    }

    public static boolean timeConstraint(long totalWorldTime, int n) {
        String str = totalWorldTime + "";
        return str.charAt(str.length() - n) == '0';
    }

    public static boolean equalNBT(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77942_o() && !stack2.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() != stack2.func_77942_o()) {
            return false;
        }
        return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
    }

    private static interface ToStringer<T> {
        public String toString(T var1);
    }

    public static class BlockWithMeta {
        Block block;
        int meta;
        boolean inverse = false;

        public BlockWithMeta(Block block) {
            this.block = block;
            this.meta = -1;
        }

        public BlockWithMeta(Block block, int meta, boolean ... inverse) {
            this.block = block;
            this.meta = meta;
            this.inverse = inverse.length > 0 && inverse[0];
        }
    }
}

