/*
 * Decompiled with CFR 0.152.
 */
package wolforce;

import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.fluids.BlockLiquidSouls;
import wolforce.items.ItemLoot;
import wolforce.recipes.RecipeNetherPortal;
import wolforce.registry.RegisterRecipes;

@Mod.EventBusSubscriber
public class HwellEvents {
    private static HashSet<String> prayers = new HashSet();

    @SubscribeEvent
    public static void checkChatForBook(ServerChatEvent event) {
        if (HwellEvents.lastChatIsValid(event.getMessage())) {
            final String username = event.getUsername();
            prayers.add(username);
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    prayers.remove(username);
                }
            }.start();
        }
    }

    @SubscribeEvent
    public static void requestBook(PlayerInteractEvent.RightClickItem event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_130014_f_().field_72995_K && HwellConfig.general.book_ritual_enabled && player.field_70125_A <= -80.0f && player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150452_aw) && player.func_184592_cb().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150452_aw) && player.func_184614_ca().func_190916_E() == 1 && player.func_184592_cb().func_190916_E() == 1 && Item.func_111206_d((String)"patchouli:guide_book") != null && prayers.contains(player.func_70005_c_())) {
            player.func_184614_ca().func_190918_g(1);
            player.func_184592_cb().func_190918_g(1);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("patchouli:book", "hwell:book_of_the_well");
            ItemStack book = new ItemStack(Item.func_111206_d((String)"patchouli:guide_book"), 1, 0, nbt);
            book.func_77983_a("patchouli:book", (NBTBase)new NBTTagString("hwell:book_of_the_well"));
            System.out.println(player.func_184614_ca());
            player.func_184611_a(EnumHand.MAIN_HAND, book);
            prayers.remove(player.func_70005_c_());
            World world = player.func_130014_f_();
            if (!world.field_72995_K) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, true));
            }
        }
    }

    private static boolean lastChatIsValid(String string) {
        if (string == null) {
            return false;
        }
        String s = string.toLowerCase();
        return s.length() > 30 && s.contains("poor") && s.contains("please") && s.contains("send") && s.contains("book") && s.contains("gods");
    }

    @SubscribeEvent
    public static void travelToDim(EntityTravelToDimensionEvent event) {
        EntityItem entityItem;
        ItemStack stackThrown;
        if (event.getEntity() instanceof EntityItem && Util.isValid(stackThrown = RecipeNetherPortal.getOutput((entityItem = (EntityItem)event.getEntity()).func_92059_d()))) {
            event.setCanceled(true);
            ItemStack newItemStack = stackThrown.func_77946_l();
            newItemStack.func_190920_e(entityItem.func_92059_d().func_190916_E() * newItemStack.func_190916_E());
            entityItem.func_92058_a(newItemStack);
        }
        if (!HwellConfig.general.allowEntitiesToTravelToTheNether && event.getDimension() == DimensionType.NETHER.func_186068_a()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.func_130014_f_().field_72995_K && RegisterRecipes.errored_recipes_file) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("HEARTH WELL WARNING - SERVER RECIPES FILE IS CORRUPTED!"));
        }
        if (!event.player.func_130014_f_().field_72995_K && RegisterRecipes.old_version_recipes_file) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("HEARTH WELL WARNING - SERVER RECIPES FILE MAY NOT BE COMPATIBLE WITH THIS VERSION! (Should be " + RegisterRecipes.recipenr + " )"));
        }
    }

    @SubscribeEvent
    public static void onEvent(ItemExpireEvent event) {
        if (event.getEntityItem().func_92059_d().func_77973_b() instanceof ItemLoot) {
            ItemLoot.entityItemExpired(event);
        }
    }

    @SubscribeEvent
    public static void onEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K) {
            HwellEvents.motion(event.player);
        }
    }

    @SubscribeEvent
    public static void onEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        List entityList = event.world.field_72996_f;
        for (int i = 0; i < entityList.size(); ++i) {
            Entity entity = (Entity)entityList.get(i);
            if (entity instanceof EntityPlayer) {
                HwellEvents.motion((EntityPlayer)entity);
                continue;
            }
            if (!(entity instanceof EntityItem)) continue;
            HwellEvents.motion((EntityItem)entity);
        }
    }

    private static void motion(EntityPlayer player) {
        if (HwellEvents.isInsideLiquidSouls(player)) {
            player.field_70181_x = player.func_70093_af() ? -0.08 : 0.08;
            player.field_70143_R = 0.0f;
        }
    }

    private static void motion(EntityItem item) {
        IBlockState bstate = item.field_70170_p.func_180495_p(item.func_180425_c());
        if (bstate.func_177230_c().equals(Main.liquid_souls_block) || bstate.func_177230_c().func_149667_c(Main.liquid_souls_block) || bstate.func_177230_c() instanceof BlockLiquidSouls) {
            BlockLiquidSouls ls = (BlockLiquidSouls)bstate.func_177230_c();
            Vec3d flow = ls.getFlowVector((IBlockAccess)item.field_70170_p, item.func_180425_c());
            item.field_70159_w += flow.field_72450_a * 0.1;
            item.field_70181_x += flow.field_72448_b * 0.1;
            item.field_70179_y += flow.field_72449_c * 0.1;
        }
    }

    private static boolean isInsideLiquidSouls(EntityPlayer player) {
        BlockPos pos1 = new BlockPos((int)player.field_70165_t - (player.field_70165_t < 0.0 ? 1 : 0), (int)player.field_70163_u, (int)player.field_70161_v - (player.field_70161_v < 0.0 ? 1 : 0));
        return player.field_70170_p.func_180495_p(pos1).func_185904_a().equals(Main.material_liquid_souls) || player.field_70170_p.func_180495_p(pos1.func_177984_a()).func_185904_a().equals(Main.material_liquid_souls);
    }
}

