/*
 * Decompiled with CFR 0.152.
 */
package wolforce;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="hwell")
@Config(modid="hwell", category="hwell_config")
public class HwellConfig {
    public static Meta meta = new Meta();
    public static General general = new General();
    public static Power power = new Power();
    public static Machines machines = new Machines();
    public static Other other = new Other();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("hwell")) {
            ConfigManager.sync((String)"hwell", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Other {
        @Config.Comment(value={"Is myst fertilizer required to see sky? (default: true)"})
        public boolean mystSaplingRequireSky = true;
        @Config.Comment(value={"Is tube required to see sky? (default: true)"})
        public boolean tubeIsRequiredToSeeSky = true;
        @Config.Comment(value={"Does tube only work in day time? (default: true)"})
        public boolean tubeIsRequiredToBeDay = true;
        @Config.Comment(value={"Is light collector required to see sky? (default: true)"})
        public boolean lightCollectorIsRequiredToSeeSky = true;
        @Config.Comment(value={"Does Light Collector only work in day time? (default: true)"})
        public boolean lightCollectorIsRequiredToBeDay = true;
        @Config.Comment(value={"Chance that you will get a shard in a picking table. (default: .333)"})
        public double pickingTableChance = 0.333;
        @Config.Comment(value={"If heat blocks explode with flint and steel. Otherwise they will just transform peacefully. (default: true)"})
        public boolean heat_blocks_explode = true;
    }

    public static class Machines {
        @Config.Comment(value={"Former Power Consumption (default: 1)"})
        public int formerConsumption = 1;
        @Config.Comment(value={"Charger Cooldown in ticks (default: 100)"})
        public int nourisherCooldown = 100;
        @Config.Comment(value={"Nourisher Power Consumption (default: 5)"})
        public int nourisherConsumption = 5;
        @Config.Comment(value={"Nourisher Range (default: 4)"})
        public int nourisherRange = 4;
        @Config.Comment(value={"Does the Nourisher only work on normal crops or on all Growables (sapplings and other)? (default: true)"})
        public boolean nourisherOnlyGrowCrops = true;
        @Config.Comment(value={"Charger Cooldown in ticks (default: 20)"})
        public int chargerCooldown = 20;
        @Config.Comment(value={"Setter Base Range (default: 4)"})
        public int setterBaseRange = 4;
        @Config.Comment(value={"Setter Power Consumption (default: 15)"})
        public int setterConsumption = 15;
        @Config.Comment(value={"Puller Power Consumption per Operation (default: 100)"})
        public int pullerConsumption = 50;
        @Config.Comment(value={"Puller Delay Between pulls (default: 3000)"})
        public int pullerDelay = 3000;
        @Config.Comment(value={"Puller chance to get a filtered item (default: 0.5)"})
        public double pullerChanceToGetFilteredPull = 0.5;
        @Config.Comment(value={"Grinder Power Consumption per Operation (default: 100)"})
        public int grinderConsumption = 12;
        @Config.Comment(value={"Separator Power Consumption per Operation (default: 100)"})
        public int separatorConsumption = 25;
        @Config.Comment(value={"Freezer Power Consumption per Operation  (default: 30)"})
        public int freezerConsumption = 5;
        @Config.Comment(value={"Range of freezer? (default: 5)"})
        @Config.RangeInt(min=1, max=16)
        public int freezerRange = 2;
        @Config.Comment(value={"Does freezer only work in night time? (default: true)"})
        public boolean freezerIsRequiredToBeNight = true;
        @Config.Comment(value={"Number of ticks that a loot kit need to hatch. 20 ticks = 1 second. (default: 600)"})
        @Config.RangeInt(min=40, max=16000)
        public int producerTimeToHatch = 600;
        @Config.Comment(value={"Charger Cooldown in ticks (default: 100)"})
        public int producerConsumption = 25;
        @Config.Comment(value={"Range of Gravity Block? (default: 5)"})
        @Config.RangeInt(min=1, max=16)
        public int gravityBlockRange = 5;
        @Config.Comment(value={"Range of Mini Gravity Block? (default: 1)"})
        @Config.RangeInt(min=1, max=16)
        public int gravityBlockRangeMini = 1;
        @Config.Comment(value={"Number of boxes a boxer spawns (default: 32)"})
        @Config.RangeInt(min=1, max=64)
        public int boxerNrOfBoxesSpawned = 32;
    }

    public static class Power {
        @Config.Comment(value={"Max range that Power Providers (Power Crystals) will provide power to machines. (default: 10)"})
        public int powerMaxRange = 10;
        @Config.Comment(value={"Do Power Crystals drop when they become empty? (default: false)"})
        public boolean powerCrystalDropsWhenEmpty = false;
    }

    public static class General {
        @Config.Comment(value={"Build multiblocks automatically when they are needed.", "This should always be false except for debugging (default: false)"})
        public boolean isAutomaticMultiblocks = false;
        @Config.Comment(value={"Allow Entities to travel to the nether (Players, mobs and animals, items, etc) (default: false)"})
        public boolean allowEntitiesToTravelToTheNether = false;
        @Config.Comment(value={"Allow player to perform the Book Ritual (default: true)"})
        public boolean book_ritual_enabled = true;
    }

    public static class Meta {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Are the recipes config able? (default: false)"})
        public boolean customRecipesEnabled = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Where the base recipes file is located (default: config/hwell_recipes.json)"})
        public String recipeFileLocation = "config/hwell_recipes.json";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Particles Id for Hearth Well start at this number (default: 291)"})
        public int particleIdStart = 291;
    }
}

