/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import integration.jei.JeiCatCoring;
import integration.jei.JeiCatCrushing;
import integration.jei.JeiCatFreezing;
import integration.jei.JeiCatGrinding;
import integration.jei.JeiCatSeparating;
import integration.jei.JeiCatTubing;
import java.util.Map;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCore;
import wolforce.registry.RegisterRecipes;

@JEIPlugin
public class JeiIntegration
implements IModPlugin {
    private IIngredientRegistry ingReg;

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IJeiHelpers helpers = reg.getJeiHelpers();
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, Main.core_stone)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, Main.core_anima)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, Main.core_heat)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, Main.core_green)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, Main.core_sentient)});
        for (Map.Entry<String, BlockCore> entry : Main.custom_cores.entrySet()) {
            BlockCore core = entry.getValue();
            reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCoring(helpers, core)});
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatCrushing(helpers)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatGrinding(helpers)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatSeparating(helpers)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatTubing(helpers)});
        reg.addRecipeCategories(new IRecipeCategory[]{new JeiCatFreezing(helpers)});
    }

    public void register(IModRegistry reg) {
        this.ingReg = reg.getIngredientRegistry();
        IJeiHelpers jeiHelpers = reg.getJeiHelpers();
        reg.addRecipes(JeiCatCoring.getAllRecipes(Main.core_stone), "hwell.coring.stone");
        reg.addRecipes(JeiCatCoring.getAllRecipes(Main.core_anima), "hwell.coring.anima");
        reg.addRecipes(JeiCatCoring.getAllRecipes(Main.core_heat), "hwell.coring.heat");
        reg.addRecipes(JeiCatCoring.getAllRecipes(Main.core_green), "hwell.coring.green");
        reg.addRecipes(JeiCatCoring.getAllRecipes(Main.core_sentient), "hwell.coring.sentient");
        for (Map.Entry<String, BlockCore> entry : Main.custom_cores.entrySet()) {
            BlockCore core = entry.getValue();
            reg.addRecipes(JeiCatCoring.getAllRecipes(core), JeiCatCoring.makeCustomCoreUID(core));
        }
        reg.addRecipes(JeiCatCrushing.getAllRecipes(), "hwell.crushing");
        reg.addRecipes(JeiCatGrinding.getAllRecipes(), "hwell.grinding");
        reg.addRecipes(JeiCatSeparating.getAllRecipes(), "hwell.separating");
        reg.addRecipes(JeiCatTubing.getAllRecipes(), "hwell.tubing");
        reg.addRecipes(JeiCatFreezing.getAllRecipes(), "hwell.freezing");
        reg.addIngredientInfo((Object)new ItemStack(Main.crystal_nether), VanillaTypes.ITEM, new String[]{"Obtained by throwing a crystal into the nether portal."});
        reg.addIngredientInfo((Object)new ItemStack((Block)Main.core_anima), VanillaTypes.ITEM, new String[]{"Obtained by growing an Inert Seed.", "You must stay near it."});
        reg.addIngredientInfo((Object)new ItemStack((Block)Main.core_heat), VanillaTypes.ITEM, new String[]{"Obtained by right clicking a Heat Block with a flint and steel.", "Just be careful..."});
        reg.addIngredientInfo((Object)new ItemStack(Main.empty_rod), VanillaTypes.ITEM, new String[]{"Hold right click to use."});
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("patchouli:book", "hwell:book_of_the_well");
        ItemStack book = new ItemStack(Item.func_111206_d((String)"patchouli:guide_book"), 1, 0, nbt);
        book.func_77983_a("patchouli:book", (NBTBase)new NBTTagString("hwell:book_of_the_well"));
        reg.addIngredientInfo((Object)book, VanillaTypes.ITEM, new String[]{"To get this item you need two wooden pressure plates, one on each hand. Then say a heartfelt prayer to the gods containing the words \"poor\", \"please\", \"send\", \"book\", \"gods\". Quickly after that, while looking directly up, smash the pressure plates together with right click!"});
        reg.addRecipes(Util.listOfOne(RegisterRecipes.recipePowerCrystal), "minecraft.crafting");
    }
}

