/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.recipes.RecipeTube;

public class JeiCatTubing
implements IRecipeCategory {
    public static final String UID_TUBING = "hwell.tubing";
    static final ResourceLocation TEX = Util.res("textures/gui/tubing.png");
    static IDrawableStatic back;
    private static IDrawable icon;

    public JeiCatTubing(IJeiHelpers helpers) {
        IGuiHelper gui = helpers.getGuiHelper();
        back = gui.drawableBuilder(TEX, 0, 0, 70, 90).setTextureSize(70, 90).build();
        icon = gui.createDrawableIngredient((Object)new ItemStack(Main.furnace_tube));
    }

    public String getUid() {
        return UID_TUBING;
    }

    public String getTitle() {
        return "Tube Recipes";
    }

    public IDrawable getIcon() {
        return icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 8, 32);
        stacks.init(1, true, 8, 64);
        if (!ingredients.getOutputs(VanillaTypes.ITEM).isEmpty()) {
            stacks.init(2, false, 44, 64);
        }
        stacks.set(ingredients);
        if (!ingredients.getOutputs(VanillaTypes.FLUID).isEmpty()) {
            recipeLayout.getFluidStacks().init(0, false, 45, 65);
            recipeLayout.getFluidStacks().set(ingredients);
        }
    }

    public static Collection<?> getAllRecipes() {
        LinkedList<1> recipeWrappers = new LinkedList<1>();
        for (final RecipeTube recipe : RecipeTube.recipes) {
            IRecipeWrapper recipeWrapper = new IRecipeWrapper(){

                public void getIngredients(IIngredients ingredients) {
                    List<ItemStack> inputs = Util.listOfOne(new ItemStack(Main.furnace_tube));
                    inputs.add(recipe.in);
                    ingredients.setInputs(VanillaTypes.ITEM, inputs);
                    if (Util.isValid(recipe.out)) {
                        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.out);
                    }
                    if (recipe.outFluid != null) {
                        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.outFluid);
                    }
                }
            };
            recipeWrappers.add(recipeWrapper);
        }
        return recipeWrappers;
    }
}

