/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.recipes.Irio;
import wolforce.recipes.RecipeSeparator;

public class JeiCatSeparating<T extends JeiRecSeparating>
implements IRecipeCategory<JeiRecSeparating> {
    public static final String UID_SEPARATOR = "hwell.separating";
    static final ResourceLocation TEX = Util.res("textures/gui/separating.png");
    static IDrawableStatic back;
    private static IDrawable icon;

    public JeiCatSeparating(IJeiHelpers helpers) {
        IGuiHelper gui = helpers.getGuiHelper();
        back = gui.drawableBuilder(TEX, 0, 0, 106, 108).setTextureSize(106, 108).build();
        icon = gui.createDrawableIngredient((Object)new ItemStack(Main.separator));
    }

    public String getUid() {
        return UID_SEPARATOR;
    }

    public String getTitle() {
        return "Separator Recipes";
    }

    public IDrawable getIcon() {
        return icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecSeparating recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 44, 45);
        stacks.init(1, true, 44, 8);
        stacks.init(2, false, 8, 45);
        stacks.init(3, false, 80, 45);
        stacks.init(4, false, 44, 82);
        stacks.set(ingredients);
    }

    public static List<JeiRecSeparating> getAllRecipes() {
        LinkedList<JeiRecSeparating> list = new LinkedList<JeiRecSeparating>();
        for (Map.Entry<Irio, RecipeSeparator> entry : RecipeSeparator.getRecipes()) {
            JeiRecSeparating recipe = new JeiRecSeparating(entry.getKey(), entry.getValue());
            System.out.println("added jei separator recipe: " + recipe);
            list.add(recipe);
        }
        return list;
    }

    public static class JeiRecSeparating
    implements IRecipeWrapper {
        private ItemStack separator = new ItemStack(Main.separator);
        private ItemStack in;
        private ItemStack out1;
        private ItemStack out2;
        private ItemStack out3;

        public JeiRecSeparating(Irio in, RecipeSeparator recipe) {
            this.in = in.stack();
            this.out1 = recipe.left;
            this.out2 = recipe.right;
            this.out3 = recipe.back;
        }

        public void getIngredients(IIngredients ingredients) {
            LinkedList<List<ItemStack>> ins = new LinkedList<List<ItemStack>>();
            ins.add(Util.listOfOne(this.separator));
            ins.add(Util.listOfOne(this.in));
            ingredients.setInputLists(ItemStack.class, ins);
            LinkedList<List<ItemStack>> outs = new LinkedList<List<ItemStack>>();
            outs.add(Util.listOfOne(this.out1));
            outs.add(Util.listOfOne(this.out2));
            outs.add(Util.listOfOne(this.out3));
            ingredients.setOutputLists(ItemStack.class, outs);
        }

        public String toString() {
            return "[ " + this.in.func_77977_a() + " -> " + this.out1.func_190916_E() + "x" + this.out1.func_77977_a() + "," + this.out2.func_190916_E() + "x" + this.out2.func_77977_a() + "," + this.out3.func_190916_E() + "x" + this.out3.func_77977_a() + " ]";
        }
    }
}

