/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.items.ItemGrindingWheel;
import wolforce.recipes.Irio;
import wolforce.recipes.RecipeGrinding;

public class JeiCatGrinding<T extends JeiRecGrinding>
implements IRecipeCategory<JeiRecGrinding> {
    public static final String UID_GRINDING = "hwell.grinding";
    static final ResourceLocation TEX = Util.res("textures/gui/grinding.png");
    static IDrawableStatic back;
    private static IDrawable icon;

    public JeiCatGrinding(IJeiHelpers helpers) {
        IGuiHelper gui = helpers.getGuiHelper();
        back = gui.drawableBuilder(TEX, 0, 0, 86, 86).setTextureSize(86, 86).build();
        icon = gui.createDrawableIngredient((Object)new ItemStack(Main.precision_grinder_empty));
    }

    public String getUid() {
        return UID_GRINDING;
    }

    public String getTitle() {
        return "Grinding Recipes";
    }

    public IDrawable getIcon() {
        return icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecGrinding recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 8, 34);
        stacks.init(1, true, 60, 34);
        stacks.init(2, true, 34, 8);
        stacks.init(3, false, 34, 60);
        stacks.set(ingredients);
    }

    public static List<JeiRecGrinding> getAllRecipes() {
        LinkedList<JeiRecGrinding> list = new LinkedList<JeiRecGrinding>();
        for (Map.Entry<Irio, RecipeGrinding> entry : RecipeGrinding.getRecipeList()) {
            JeiRecGrinding recipe = new JeiRecGrinding(entry.getKey(), entry.getValue());
            System.out.println("added jei crushing recipe: " + recipe);
            list.add(recipe);
        }
        return list;
    }

    public static class JeiRecGrinding
    implements IRecipeWrapper {
        private List<ItemStack> grinder;
        private List<ItemStack> grindingWheel;
        private List<ItemStack> in;
        private ItemStack out;
        private RecipeGrinding result;

        public JeiRecGrinding(Irio in, RecipeGrinding recipeGrinding) {
            this.result = recipeGrinding;
            this.grinder = Util.listOfOneItemStack(Main.precision_grinder_empty);
            this.grindingWheel = new LinkedList<ItemStack>();
            for (ItemGrindingWheel wheel : recipeGrinding.levels) {
                this.grindingWheel.add(new ItemStack((Item)wheel));
            }
            if (in.item.func_77614_k()) {
                NonNullList itemSubtypes = NonNullList.func_191196_a();
                in.item.func_150895_a(CreativeTabs.field_78027_g, itemSubtypes);
                this.in = itemSubtypes;
            }
            this.in = Util.listOfOne(in.stack());
            this.out = recipeGrinding.result;
        }

        public void getIngredients(IIngredients ingredients) {
            LinkedList<List<ItemStack>> ins = new LinkedList<List<ItemStack>>();
            ins.add(this.grinder);
            ins.add(this.grindingWheel);
            ins.add(this.in);
            ingredients.setInputLists(ItemStack.class, ins);
            ingredients.setOutput(ItemStack.class, (Object)this.out);
        }

        public String toString() {
            return "[ " + this.in.get(0).func_190916_E() + "x" + this.in.get(0).func_77977_a() + " -> " + this.out.func_190916_E() + "x" + this.out.func_77977_a() + " ]";
        }
    }
}

