/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.recipes.RecipeFreezer;

public class JeiCatFreezing
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID_FREEZING = "hwell.freezing";
    static final ResourceLocation TEX = Util.res("textures/gui/freezing.png");
    static IDrawableStatic back;
    private static IDrawable icon;

    public JeiCatFreezing(IJeiHelpers helpers) {
        IGuiHelper gui = helpers.getGuiHelper();
        back = gui.drawableBuilder(TEX, 0, 0, 98, 56).setTextureSize(98, 56).build();
        icon = gui.createDrawableIngredient((Object)new ItemStack(Main.freezer));
    }

    public String getUid() {
        return UID_FREEZING;
    }

    public String getTitle() {
        return "Freezer Recipes";
    }

    public IDrawable getIcon() {
        return icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 40, 30);
        stacks.init(1, false, 72, 30);
        stacks.set(ingredients);
        recipeLayout.getFluidStacks().init(0, true, 9, 31);
        recipeLayout.getFluidStacks().set(ingredients);
    }

    public static Collection<?> getAllRecipes() {
        LinkedList<1> recipeWrappers = new LinkedList<1>();
        for (final RecipeFreezer recipe : RecipeFreezer.recipes) {
            IRecipeWrapper recipeWrapper = new IRecipeWrapper(){

                public void getIngredients(IIngredients ingredients) {
                    ingredients.setInputs(VanillaTypes.FLUID, Util.listOfOne(recipe.fluidIn));
                    ingredients.setInputs(VanillaTypes.ITEM, Util.listOfOne(new ItemStack(Main.freezer)));
                    ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.blocksOut));
                }
            };
            recipeWrappers.add(recipeWrapper);
        }
        return recipeWrappers;
    }
}

