/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.recipes.Irio;
import wolforce.recipes.RecipeCrushing;

public class JeiCatCrushing<T extends JeiRecCrushing>
implements IRecipeCategory<JeiRecCrushing> {
    public static final String UID_CRUSHING = "hwell.crushing";
    static final ResourceLocation TEX = Util.res("textures/gui/crushing.png");
    static IDrawableStatic back;
    private static IDrawable icon;

    public JeiCatCrushing(IJeiHelpers helpers) {
        IGuiHelper gui = helpers.getGuiHelper();
        back = gui.drawableBuilder(TEX, 0, 0, 60, 86).setTextureSize(60, 86).build();
        icon = gui.createDrawableIngredient((Object)new ItemStack(Main.crushing_block));
    }

    public String getUid() {
        return UID_CRUSHING;
    }

    public String getTitle() {
        return "Crushing Recipes";
    }

    public IDrawable getIcon() {
        return icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecCrushing recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 8, 34);
        stacks.init(1, true, 34, 8);
        stacks.init(2, false, 34, 60);
        stacks.set(ingredients);
    }

    public static List<JeiRecCrushing> getAllRecipes() {
        LinkedList<JeiRecCrushing> list = new LinkedList<JeiRecCrushing>();
        for (Map.Entry<Irio, RecipeCrushing[]> entry : RecipeCrushing.getRecipeList()) {
            JeiRecCrushing recipe = new JeiRecCrushing(entry.getKey(), entry.getValue());
            System.out.println("added jei crushing recipe: " + recipe);
            list.add(recipe);
        }
        return list;
    }

    public static class JeiRecCrushing
    implements IRecipeWrapper {
        private ItemStack crushingBlock;
        private ItemStack in;
        private List<ItemStack> out;
        private RecipeCrushing[] results;

        public JeiRecCrushing(Irio in, RecipeCrushing[] results) {
            this.results = results;
            this.crushingBlock = new ItemStack(Main.crushing_block);
            this.in = in.stack();
            this.out = new LinkedList<ItemStack>();
            for (int i = 0; i < results.length; ++i) {
                this.out.add(results[i].stack);
            }
        }

        public void getIngredients(IIngredients ingredients) {
            LinkedList<ItemStack> ins = new LinkedList<ItemStack>();
            ins.add(this.crushingBlock);
            ins.add(this.in);
            ingredients.setInputs(ItemStack.class, ins);
            ingredients.setOutput(ItemStack.class, this.out);
        }

        public String toString() {
            return "[ " + this.in.func_77977_a() + " -> " + this.out.size() + " ]";
        }
    }
}

