/*
 * Decompiled with CFR 0.152.
 */
package integration.jei;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCore;
import wolforce.recipes.Irio;
import wolforce.recipes.RecipeCoring;

public class JeiCatCoring<T extends JeiRecCoring>
implements IRecipeCategory<JeiRecCoring> {
    public static final String UID_CORING_STONE = "hwell.coring.stone";
    public static final String UID_CORING_ANIMA = "hwell.coring.anima";
    public static final String UID_CORING_HEAT = "hwell.coring.heat";
    public static final String UID_CORING_GREEN = "hwell.coring.green";
    public static final String UID_CORING_SENTIENT = "hwell.coring.sentient";
    static final ResourceLocation TEX = Util.res("textures/gui/coring.png");
    static IDrawableStatic back;
    private IDrawable icon;
    private BlockCore core;

    public static String makeCustomCoreUID(BlockCore core) {
        return "hwell.coring." + core.getRegistryName().func_110623_a();
    }

    public JeiCatCoring(IJeiHelpers helpers, BlockCore core) {
        IGuiHelper gui = helpers.getGuiHelper();
        this.core = core;
        back = gui.drawableBuilder(TEX, 0, 0, 62, 90).setTextureSize(62, 90).build();
        this.icon = gui.createDrawableIngredient((Object)new ItemStack((Block)core));
    }

    public String getUid() {
        if (this.core == Main.core_stone) {
            return UID_CORING_STONE;
        }
        if (this.core == Main.core_anima) {
            return UID_CORING_ANIMA;
        }
        if (this.core == Main.core_heat) {
            return UID_CORING_HEAT;
        }
        if (this.core == Main.core_green) {
            return UID_CORING_GREEN;
        }
        if (this.core == Main.core_sentient) {
            return UID_CORING_SENTIENT;
        }
        for (Map.Entry<String, BlockCore> entry : Main.custom_cores.entrySet()) {
            if (!entry.getValue().equals(this.core)) continue;
            return JeiCatCoring.makeCustomCoreUID(this.core);
        }
        return "";
    }

    public String getTitle() {
        return "Coring Recipes";
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getModName() {
        return "hwell";
    }

    public IDrawable getBackground() {
        return back;
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecCoring recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, false, 22, 64);
        stacks.init(1, true, 8, 8);
        stacks.init(2, true, 36, 8);
        stacks.init(3, true, 8, 34);
        stacks.set(ingredients);
    }

    public static List<JeiRecCoring> getAllRecipes(BlockCore core) {
        LinkedList<JeiRecCoring> list = new LinkedList<JeiRecCoring>();
        for (Map.Entry<Item, RecipeCoring> entry : RecipeCoring.getRecipeList(core)) {
            JeiRecCoring recipe = new JeiRecCoring((Block)core, entry.getKey(), entry.getValue().consumes, entry.getValue().result);
            System.out.println("added jei core " + core.func_149732_F() + " recipe: " + recipe);
            list.add(recipe);
        }
        return list;
    }

    public static class JeiRecCoring
    implements IRecipeWrapper {
        private List<ItemStack> shard;
        private List<ItemStack> consumes;
        private List<ItemStack> coretype = new LinkedList<ItemStack>();
        private List<ItemStack> out;

        public JeiRecCoring(Block coretype, Item shard, Irio[] consumes, ItemStack result) {
            this(coretype, shard, consumes, new ItemStack[]{result});
        }

        public JeiRecCoring(Block coretype, Item shard, Irio[] consumes, ItemStack[] result) {
            this.coretype.add(new ItemStack(coretype));
            this.shard = new LinkedList<ItemStack>();
            this.shard.add(new ItemStack(shard));
            this.consumes = new LinkedList<ItemStack>();
            for (Irio irio : consumes) {
                this.consumes.add(irio.stack());
            }
            this.out = new LinkedList<ItemStack>();
            for (Irio irio : result) {
                this.out.add((ItemStack)irio);
            }
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> ins = new ArrayList<List<ItemStack>>(4);
            ins.add(this.coretype);
            ins.add(this.shard);
            ins.add(this.consumes);
            ingredients.setInputLists(ItemStack.class, ins);
            ingredients.setOutput(ItemStack.class, this.out);
        }

        public String toString() {
            return "[ " + this.shard.get(0).func_77977_a() + " -> " + this.out.get(0).func_77977_a() + " consuming " + this.consumes.size() + " ]";
        }
    }
}

