/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixinhelper;

import cf.terminator.laggoggles.Main;
import cf.terminator.laggoggles.mixinhelper.MixinConfigPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MixinValidator {
    public static void validate() {
        HashMap<String, String> FAILED_OR_UNLOADED_MIXINS = new HashMap<String, String>(MixinConfigPlugin.MIXINS_TO_LOAD);
        for (String string : new HashSet<String>(FAILED_OR_UNLOADED_MIXINS.values())) {
            try {
                Main.LOGGER.info("Loading mixin target class: " + string);
                Class.forName(string);
            }
            catch (Exception e) {
                Main.LOGGER.warn("Failed to load class: " + string + ". This is required to apply mixins!");
                e.printStackTrace();
            }
        }
        if (MixinConfigPlugin.MIXINS_TO_LOAD.size() > 0) {
            Main.LOGGER.fatal("Not all required mixins have been applied!");
            Main.LOGGER.fatal("To prevent you from wasting your time, the process has ended.");
            Main.LOGGER.fatal("");
            Main.LOGGER.fatal("Required mixins that have not been applied:");
            for (Map.Entry entry : MixinConfigPlugin.MIXINS_TO_LOAD.entrySet()) {
                Main.LOGGER.fatal("- " + (String)entry.getKey() + " targeting: " + (String)entry.getValue());
            }
            Main.LOGGER.fatal("");
            Main.LOGGER.fatal("This means that LagGoggles will not function properly.");
            Main.LOGGER.fatal("Make sure your versions are correct for Forge as well as SpongeForge.");
            Main.LOGGER.fatal("");
            FMLCommonHandler.instance().exitJava(1, false);
        } else {
            Main.LOGGER.info("All mixins have been applied. If they were not overridden by another mod, everything should work.");
        }
    }
}

