/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixin;

import cf.terminator.laggoggles.mixinhelper.extended.DynamicMethodReplacer;
import cf.terminator.laggoggles.profiler.ProfileManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.mixin.core.world.WorldServerMixin;

@Mixin(value={WorldServer.class}, priority=1001)
public abstract class MixinWorldServerSponge
extends World {
    protected MixinWorldServerSponge(ISaveHandler a, WorldInfo b, WorldProvider c, Profiler d, boolean e) {
        super(a, b, c, d, e);
        throw new RuntimeException("Mixins cannot be instantiated.");
    }

    @DynamicMethodReplacer.RedirectMethodCalls(nameRegexDeobf="randomTick", nameRegexObf="func_180645_a", convertSelf=true)
    @Dynamic(value="Overwritten by SpongeForge", mixin=WorldServerMixin.class)
    private void randomBlockTickRedirectorVanilla(Block block, World world, BlockPos pos, IBlockState state, Random random) {
        long startTime = System.nanoTime();
        block.func_180645_a(world, pos, state, random);
        if (ProfileManager.PROFILE_ENABLED.get()) {
            ProfileManager.timingManager.addBlockTime(world.field_73011_w.getDimension(), pos, System.nanoTime() - startTime);
        }
    }

    @DynamicMethodReplacer.RedirectMethodCalls(nameRegexDeobf="randomTickBlock", nameRegexObf="randomTickBlock")
    @Dynamic(value="Overwritten by SpongeForge", mixin=WorldServerMixin.class)
    private static void randomBlockTickRedirectorSponge(ServerWorldBridge bridge, Block block, BlockPos pos, IBlockState state, Random random) {
        long startTime = System.nanoTime();
        TrackingUtil.randomTickBlock((ServerWorldBridge)bridge, (Block)block, (BlockPos)pos, (IBlockState)state, (Random)random);
        if (ProfileManager.PROFILE_ENABLED.get()) {
            ProfileManager.timingManager.addBlockTime(bridge.bridge$getDimensionId(), pos, System.nanoTime() - startTime);
        }
    }

    @DynamicMethodReplacer.RedirectMethodCalls(nameRegexDeobf="updateTick", nameRegexObf="func_180650_b", convertSelf=true)
    @Dynamic(value="Overwritten by SpongeForge", mixin=WorldServerMixin.class)
    private void normalBlockTickRedirectorVanilla(Block block, World world, BlockPos pos, IBlockState state, Random random) {
        long startTime = System.nanoTime();
        block.func_180650_b(world, pos, state, random);
        if (ProfileManager.PROFILE_ENABLED.get()) {
            ProfileManager.timingManager.addBlockTime(world.field_73011_w.getDimension(), pos, System.nanoTime() - startTime);
        }
    }

    @DynamicMethodReplacer.RedirectMethodCalls(nameRegexDeobf="updateTickBlock", nameRegexObf="updateTickBlock")
    @Dynamic(value="Overwritten by SpongeForge", mixin=WorldServerMixin.class)
    private static void normalBlockTickRedirectorSponge(ServerWorldBridge bridge, Block block, BlockPos pos, IBlockState state, Random random) {
        long startTime = System.nanoTime();
        TrackingUtil.updateTickBlock((ServerWorldBridge)bridge, (Block)block, (BlockPos)pos, (IBlockState)state, (Random)random);
        if (ProfileManager.PROFILE_ENABLED.get()) {
            ProfileManager.timingManager.addBlockTime(bridge.bridge$getDimensionId(), pos, System.nanoTime() - startTime);
        }
    }
}

