/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.common.enchantment;

import com.teamwizardry.librarianlib.features.base.EnchantmentMod;
import com.wiresegal.naturalpledge.api.item.IWeightEnchantable;
import com.wiresegal.naturalpledge.common.enchantment.ModEnchantments;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/wiresegal/naturalpledge/common/enchantment/EnchantmentWeight;", "Lcom/teamwizardry/librarianlib/features/base/EnchantmentMod;", "name", "", "heavy", "", "(Ljava/lang/String;Z)V", "applicableSlots", "", "Lnet/minecraft/inventory/EntityEquipmentSlot;", "getApplicableSlots", "()[Lnet/minecraft/inventory/EntityEquipmentSlot;", "getHeavy", "()Z", "calcDamageByCreature", "", "level", "", "creatureType", "Lnet/minecraft/entity/EnumCreatureAttribute;", "canApplyAtEnchantingTable", "stack", "Lnet/minecraft/item/ItemStack;", "canApplyTogether", "ench", "Lnet/minecraft/enchantment/Enchantment;", "getMaxEnchantability", "enchantmentLevel", "getMaxLevel", "getMinEnchantability", "onEntityDamaged", "", "user", "Lnet/minecraft/entity/EntityLivingBase;", "target", "Lnet/minecraft/entity/Entity;", "Companion", "NaturalPledge"})
public final class EnchantmentWeight
extends EnchantmentMod {
    private final boolean heavy;
    @NotNull
    private static final EntityEquipmentSlot[] levelSlots;
    public static final Companion Companion;

    @NotNull
    public EntityEquipmentSlot[] getApplicableSlots() {
        return levelSlots;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_77973_b() instanceof IWeightEnchantable) {
            Item item = stack.func_77973_b();
            if (item == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.wiresegal.naturalpledge.api.item.IWeightEnchantable");
            }
            return ((IWeightEnchantable)item).canApplyWeightEnchantment(stack, (Enchantment)this);
        }
        return false;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + 11 * (enchantmentLevel - 1);
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 50;
    }

    public float func_152376_a(int level, @Nullable EnumCreatureAttribute creatureType) {
        return 1.0f + (float)Math.max(0, level - 1) * 0.5f * (float)(this.heavy ? 2 : -3);
    }

    public void func_151368_a(@NotNull EntityLivingBase user, @NotNull Entity target, int level) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        double mul = this.heavy ? 0.5 * (double)(level + 1) : 5.0 / (double)(level + 4);
        target.field_70159_w *= mul;
        target.field_70179_y *= mul;
    }

    protected boolean func_77326_a(@Nullable Enchantment ench) {
        return !(ench instanceof EnchantmentWeight);
    }

    public int func_77325_b() {
        return 5;
    }

    public final boolean getHeavy() {
        return this.heavy;
    }

    public EnchantmentWeight(@NotNull String name, boolean heavy) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, Enchantment.Rarity.COMMON, ModEnchantments.INSTANCE.getWEIGHTY(), new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.heavy = heavy;
    }

    static {
        Companion = new Companion(null);
        MinecraftForge.EVENT_BUS.register((Object)Companion);
        levelSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.OFFHAND, EntityEquipmentSlot.MAINHAND};
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/wiresegal/naturalpledge/common/enchantment/EnchantmentWeight$Companion;", "", "()V", "levelSlots", "", "Lnet/minecraft/inventory/EntityEquipmentSlot;", "getLevelSlots", "()[Lnet/minecraft/inventory/EntityEquipmentSlot;", "[Lnet/minecraft/inventory/EntityEquipmentSlot;", "getWeight", "", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "stack", "Lnet/minecraft/item/ItemStack;", "updatePlayerStep", "", "e", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingUpdateEvent;", "NaturalPledge"})
    public static final class Companion {
        @SubscribeEvent
        public final void updatePlayerStep(@NotNull LivingEvent.LivingUpdateEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            EntityLivingBase player2 = e.getEntityLiving();
            if (player2 instanceof EntityPlayer) {
                int lightWeight = this.getWeight(player2);
                if ((player2.field_70122_E || ((EntityPlayer)player2).field_71075_bZ.field_75100_b) && player2.field_191988_bg > 0.0f && !player2.func_70055_a(Material.field_151586_h)) {
                    player2.func_191958_b(0.0f, 0.0f, -0.01f * (float)lightWeight, 1.0f);
                }
            }
        }

        @NotNull
        public final EntityEquipmentSlot[] getLevelSlots() {
            return levelSlots;
        }

        public final int getWeight(@NotNull EntityLivingBase entity) {
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            return ModEnchantments.INSTANCE.getHeavy().getTotalLevel(entity) - ModEnchantments.INSTANCE.getLightweight().getTotalLevel(entity);
        }

        public final int getWeight(@NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.INSTANCE.getHeavy()), (ItemStack)stack) - EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.INSTANCE.getLightweight()), (ItemStack)stack);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

