/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.common.core.helper;

import com.wiresegal.naturalpledge.common.core.helper.NPLogger;
import com.wiresegal.naturalpledge.common.lib.LibObfuscation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.CooldownTracker;
import net.minecraft.world.Explosion;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public class NPMethodHandles {
    @Nonnull
    public static final Class cooldownClass;
    @Nonnull
    private static final MethodHandle cooldownsGetter;
    @Nonnull
    private static final MethodHandle cooldownTicksGetter;
    @Nonnull
    private static final MethodHandle cooldownMaker;
    @Nonnull
    private static final MethodHandle expireTicksGetter;
    @Nonnull
    private static final MethodHandle createTicksGetter;
    @Nonnull
    private static final MethodHandle swingTicksGetter;
    @Nonnull
    private static final MethodHandle swingTicksSetter;
    @Nonnull
    private static final MethodHandle lightningEffectGetter;
    @Nonnull
    private static final MethodHandle explosionSizeGetter;
    @Nonnull
    private static final MethodHandle alwaysEdibleGetter;
    @Nonnull
    private static final MethodHandle playersWhoAttackedGetter;
    @Nonnull
    private static final MethodHandle mobSpawnTicksSetter;
    @Nonnull
    private static final MethodHandle tpDelaySetter;
    @Nonnull
    private static final MethodHandle isJumpingSetter;
    @Nonnull
    private static final MethodHandle jumpTicksGetter;
    @Nonnull
    private static final MethodHandle capturePositionInvoker;

    @Nonnull
    public static Map getCooldowns(@Nonnull CooldownTracker cooldownTracker) {
        try {
            return cooldownsGetter.invokeExact(cooldownTracker);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void addNewCooldown(@Nonnull CooldownTracker cooldownTracker, @Nonnull Item item, int createTicks, int expireTicks) {
        Map cooldowns = NPMethodHandles.getCooldowns(cooldownTracker);
        cooldowns.put(item, NPMethodHandles.newCooldown(cooldownTracker, createTicks, expireTicks));
    }

    public static int getCooldownTicks(@Nonnull CooldownTracker cooldownTracker) {
        try {
            return cooldownTicksGetter.invokeExact(cooldownTracker);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    @Nonnull
    public static Object newCooldown(@Nonnull CooldownTracker tracker, int createTicks, int expireTicks) {
        try {
            return cooldownMaker.invokeExact(tracker, createTicks, expireTicks);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static int getExpireTicks(@Nonnull Object cooldown) {
        try {
            return expireTicksGetter.invokeExact(cooldown);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static int getCreateTicks(@Nonnull Object cooldown) {
        try {
            return createTicksGetter.invokeExact(cooldown);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static int getSwingTicks(@Nonnull EntityLivingBase entity) {
        try {
            return swingTicksGetter.invokeExact(entity);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void setSwingTicks(@Nonnull EntityLivingBase entity, int ticks) {
        try {
            swingTicksSetter.invokeExact(entity, ticks);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static boolean getEffectOnly(@Nonnull EntityLightningBolt entity) {
        try {
            return lightningEffectGetter.invokeExact(entity);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static float getExplosionSize(@Nonnull Explosion entity) {
        try {
            return explosionSizeGetter.invokeExact(entity);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static boolean isAlwaysEdible(@Nonnull ItemFood food) {
        try {
            return alwaysEdibleGetter.invokeExact(food);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static List getPlayersWhoAttacked(@Nonnull EntityDoppleganger gaiaGuardian) {
        try {
            return playersWhoAttackedGetter.invokeExact(gaiaGuardian);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void setMobSpawnTicks(@Nonnull EntityDoppleganger gaiaGuardian, int ticks) {
        try {
            mobSpawnTicksSetter.invokeExact(gaiaGuardian, ticks);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void setTpDelay(@Nonnull EntityDoppleganger gaiaGuardian, int ticks) {
        try {
            tpDelaySetter.invokeExact(gaiaGuardian, ticks);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void setIsJumping(@Nonnull EntityLivingBase entity, boolean isJumping) {
        try {
            isJumpingSetter.invokeExact(entity, isJumping);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static int getJumpTicks(@Nonnull EntityLivingBase entity) {
        try {
            return jumpTicksGetter.invokeExact(entity);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    public static void captureCurrentPosition(@Nonnull NetHandlerPlayServer net) {
        try {
            capturePositionInvoker.invokeExact(net);
        }
        catch (Throwable t) {
            throw NPMethodHandles.propagate(t);
        }
    }

    private static RuntimeException propagate(Throwable t) {
        NPLogger.INSTANCE.severe("Methodhandle failed!", new Object[0]);
        t.printStackTrace();
        return new RuntimeException(t);
    }

    static {
        try {
            Field f = ReflectionHelper.findField(CooldownTracker.class, (String[])LibObfuscation.COOLDOWNTRACKER_COOLDOWNS);
            cooldownsGetter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(CooldownTracker.class, (String[])LibObfuscation.COOLDOWNTRACKER_TICKS);
            cooldownTicksGetter = MethodHandles.publicLookup().unreflectGetter(f);
            cooldownClass = Class.forName("net.minecraft.util.CooldownTracker$Cooldown");
            Constructor ctor = cooldownClass.getDeclaredConstructor(CooldownTracker.class, Integer.TYPE, Integer.TYPE);
            ctor.setAccessible(true);
            cooldownMaker = MethodHandles.publicLookup().unreflectConstructor(ctor).asType(MethodType.methodType(Object.class, CooldownTracker.class, Integer.TYPE, Integer.TYPE));
            f = ReflectionHelper.findField((Class)cooldownClass, (String[])LibObfuscation.COOLDOWN_EXPIRETICKS);
            expireTicksGetter = MethodHandles.publicLookup().unreflectGetter(f).asType(MethodType.methodType(Integer.TYPE, Object.class));
            f = ReflectionHelper.findField((Class)cooldownClass, (String[])LibObfuscation.COOLDOWN_CREATETICKS);
            createTicksGetter = MethodHandles.publicLookup().unreflectGetter(f).asType(MethodType.methodType(Integer.TYPE, Object.class));
            f = ReflectionHelper.findField(EntityLivingBase.class, (String[])LibObfuscation.ENTITYLIVINGBASE_TICKSSINCELASTSWING);
            swingTicksGetter = MethodHandles.publicLookup().unreflectGetter(f);
            swingTicksSetter = MethodHandles.publicLookup().unreflectSetter(f);
            f = ReflectionHelper.findField(EntityLightningBolt.class, (String[])LibObfuscation.ENTITYLIGHTNINGBOLT_EFFECTONLY);
            lightningEffectGetter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(Explosion.class, (String[])LibObfuscation.EXPLOSION_EXPLOSIONSIZE);
            explosionSizeGetter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(ItemFood.class, (String[])LibObfuscation.ITEMFOOD_ALWAYSEDIBLE);
            alwaysEdibleGetter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(EntityDoppleganger.class, (String[])new String[]{"playersWhoAttacked"});
            playersWhoAttackedGetter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(EntityDoppleganger.class, (String[])new String[]{"mobSpawnTicks"});
            mobSpawnTicksSetter = MethodHandles.publicLookup().unreflectSetter(f);
            f = ReflectionHelper.findField(EntityDoppleganger.class, (String[])new String[]{"tpDelay"});
            tpDelaySetter = MethodHandles.publicLookup().unreflectSetter(f);
            f = ReflectionHelper.findField(EntityLivingBase.class, (String[])LibObfuscation.ENTITYLIVINGBASE_ISJUMPING);
            isJumpingSetter = MethodHandles.publicLookup().unreflectSetter(f);
            f = ReflectionHelper.findField(EntityLivingBase.class, (String[])LibObfuscation.ENTITYLIVINGBASE_JUMPTICKS);
            jumpTicksGetter = MethodHandles.publicLookup().unreflectGetter(f);
            Method m = ReflectionHelper.findMethod(NetHandlerPlayServer.class, (String)LibObfuscation.NETHANDLERPLAYSERVER_CAPTURECURRENTPOSITION[2], (String)LibObfuscation.NETHANDLERPLAYSERVER_CAPTURECURRENTPOSITION[1], (Class[])new Class[0]);
            capturePositionInvoker = MethodHandles.publicLookup().unreflect(m);
        }
        catch (Throwable t) {
            NPLogger.INSTANCE.severe("Couldn't initialize methodhandles! Things will be broken!", new Object[0]);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }
}

