/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.common.core.helper;

import com.wiresegal.naturalpledge.common.NaturalPledge;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0015J7\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/wiresegal/naturalpledge/common/core/helper/NPLogger;", "", "()V", "coreLog", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getCoreLog", "()Lorg/apache/logging/log4j/Logger;", "bigWarning", "", "format", "", "data", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "fine", "finer", "info", "log", "level", "Lorg/apache/logging/log4j/Level;", "(Lorg/apache/logging/log4j/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "ex", "", "(Lorg/apache/logging/log4j/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "severe", "warning", "NaturalPledge"})
public final class NPLogger {
    private static final Logger coreLog;
    public static final NPLogger INSTANCE;

    public final Logger getCoreLog() {
        return coreLog;
    }

    public final void log(@NotNull Level level, @NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        coreLog.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void log(@NotNull Level level, @NotNull Throwable ex, @NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)level, (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = format;
        Object[] objectArray = Arrays.copyOf(data, data.length);
        Level level2 = level;
        Logger logger = coreLog;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        String string3 = string2;
        logger.log(level2, string3, ex);
    }

    public final void severe(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Level level = Level.ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.ERROR");
        this.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void warning(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Level level = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.WARN");
        this.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void info(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Level level = Level.INFO;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.INFO");
        this.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void fine(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void finer(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        this.log(level, format, Arrays.copyOf(data, data.length));
    }

    public final void bigWarning(@NotNull String format, Object ... data) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        StackTraceElement[] trace = thread.getStackTrace();
        Level level = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.WARN");
        this.log(level, "****************************************", new Object[0]);
        Level level2 = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.WARN");
        this.log(level2, "* " + format, Arrays.copyOf(data, data.length));
        for (int i = 2; i < 8 && i < trace.length; ++i) {
            Level level3 = Level.WARN;
            Intrinsics.checkExpressionValueIsNotNull((Object)level3, (String)"Level.WARN");
            Object[] objectArray = new Object[2];
            String string = trace[i].toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trace[i].toString()");
            objectArray[0] = string;
            objectArray[1] = i == 7 ? "..." : "";
            this.log(level3, "*  at %s%s", objectArray);
        }
        Level level4 = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level4, (String)"Level.WARN");
        this.log(level4, "****************************************", new Object[0]);
    }

    private NPLogger() {
    }

    static {
        NPLogger nPLogger;
        INSTANCE = nPLogger = new NPLogger();
        coreLog = NaturalPledge.Companion.getLOGGER();
    }
}

