/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.common.core.helper;

import com.wiresegal.naturalpledge.common.core.helper.NPMethodHandles;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.util.CooldownTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/wiresegal/naturalpledge/common/core/helper/CooldownHelper;", "", "()V", "getCooldown", "Lcom/wiresegal/naturalpledge/common/core/helper/CooldownHelper$CooldownWrapper;", "cooldownTracker", "Lnet/minecraft/util/CooldownTracker;", "item", "Lnet/minecraft/item/Item;", "setCooldown", "", "startTime", "", "expireTime", "CooldownWrapper", "NaturalPledge"})
public final class CooldownHelper {
    public static final CooldownHelper INSTANCE;

    public final void setCooldown(@NotNull CooldownTracker cooldownTracker, @NotNull Item item, int startTime, int expireTime) {
        Intrinsics.checkParameterIsNotNull((Object)cooldownTracker, (String)"cooldownTracker");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int ticks = NPMethodHandles.getCooldownTicks(cooldownTracker);
        if (expireTime <= ticks || startTime > ticks) {
            return;
        }
        NPMethodHandles.addNewCooldown(cooldownTracker, item, startTime, expireTime);
    }

    @Nullable
    public final CooldownWrapper getCooldown(@NotNull CooldownTracker cooldownTracker, @NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)cooldownTracker, (String)"cooldownTracker");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Map cooldowns = NPMethodHandles.getCooldowns(cooldownTracker);
        Object v = cooldowns.get(item);
        if (v == null) {
            return null;
        }
        Object cooldown = v;
        return new CooldownWrapper(NPMethodHandles.getCreateTicks(cooldown), NPMethodHandles.getExpireTicks(cooldown));
    }

    private CooldownHelper() {
    }

    static {
        CooldownHelper cooldownHelper;
        INSTANCE = cooldownHelper = new CooldownHelper();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/wiresegal/naturalpledge/common/core/helper/CooldownHelper$CooldownWrapper;", "", "createTicks", "", "expireTicks", "(II)V", "getCreateTicks", "()I", "getExpireTicks", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "NaturalPledge"})
    public static final class CooldownWrapper {
        private final int createTicks;
        private final int expireTicks;

        public final int getCreateTicks() {
            return this.createTicks;
        }

        public final int getExpireTicks() {
            return this.expireTicks;
        }

        public CooldownWrapper(int createTicks, int expireTicks) {
            this.createTicks = createTicks;
            this.expireTicks = expireTicks;
        }

        public final int component1() {
            return this.createTicks;
        }

        public final int component2() {
            return this.expireTicks;
        }

        @NotNull
        public final CooldownWrapper copy(int createTicks, int expireTicks) {
            return new CooldownWrapper(createTicks, expireTicks);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CooldownWrapper copy$default(CooldownWrapper cooldownWrapper, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = cooldownWrapper.createTicks;
            }
            if ((n3 & 2) != 0) {
                n2 = cooldownWrapper.expireTicks;
            }
            return cooldownWrapper.copy(n, n2);
        }

        public String toString() {
            return "CooldownWrapper(createTicks=" + this.createTicks + ", expireTicks=" + this.expireTicks + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.createTicks) * 31 + Integer.hashCode(this.expireTicks);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CooldownWrapper)) break block3;
                    CooldownWrapper cooldownWrapper = (CooldownWrapper)object;
                    if (!(this.createTicks == cooldownWrapper.createTicks) || !(this.expireTicks == cooldownWrapper.expireTicks)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

