/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.common.block.dendrics.sealing;

import com.wiresegal.naturalpledge.api.sapling.ISealingBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/wiresegal/naturalpledge/common/block/dendrics/sealing/SoundSealEventHandler;", "", "()V", "MAXRANGE", "", "getMAXRANGE", "()I", "dist", "", "pos1", "Lnet/minecraft/util/math/BlockPos;", "pos2", "onPlaySound", "", "e", "Lnet/minecraftforge/client/event/sound/PlaySoundEvent;", "VolumeModSound", "NaturalPledge"})
public final class SoundSealEventHandler {
    private static final int MAXRANGE = 16;
    public static final SoundSealEventHandler INSTANCE;

    public final int getMAXRANGE() {
        return MAXRANGE;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void onPlaySound(@NotNull PlaySoundEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (Minecraft.func_71410_x().field_71441_e != null && e.getResultSound() != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!(e.getResultSound() instanceof ITickableSound)) {
                ISound iSound = e.getResultSound();
                Intrinsics.checkExpressionValueIsNotNull((Object)iSound, (String)"e.resultSound");
                double x = iSound.func_147649_g();
                ISound iSound2 = e.getResultSound();
                Intrinsics.checkExpressionValueIsNotNull((Object)iSound2, (String)"e.resultSound");
                double y = iSound2.func_147654_h();
                ISound iSound3 = e.getResultSound();
                Intrinsics.checkExpressionValueIsNotNull((Object)iSound3, (String)"e.resultSound");
                double z = iSound3.func_147651_i();
                float volumeMultiplier = 1.0f;
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(x - (double)MAXRANGE, y - (double)MAXRANGE, z - (double)MAXRANGE), (BlockPos)new BlockPos(x + (double)MAXRANGE, y + (double)MAXRANGE, z + (double)MAXRANGE))) {
                    IBlockState state;
                    IBlockState iBlockState = state = world.func_180495_p(pos);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                    Block block = iBlockState.func_177230_c();
                    if (!(block instanceof ISealingBlock)) continue;
                    BlockPos blockPos = pos;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                    double distance = this.dist(blockPos, new BlockPos(x, y, z));
                    if (!(distance <= (double)MAXRANGE) || !((ISealingBlock)block).canSeal(state, (World)world, pos, distance, e)) continue;
                    volumeMultiplier *= ((ISealingBlock)block).getVolumeMultiplier(state, (World)world, pos, distance, e);
                }
                if (volumeMultiplier != 1.0f) {
                    ISound iSound4 = e.getResultSound();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iSound4, (String)"e.resultSound");
                    e.setResultSound((ISound)new VolumeModSound(iSound4, volumeMultiplier));
                }
            }
        }
    }

    private final double dist(BlockPos pos1, BlockPos pos2) {
        return pos1.func_185332_f(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    private SoundSealEventHandler() {
    }

    static {
        SoundSealEventHandler soundSealEventHandler;
        INSTANCE = soundSealEventHandler = new SoundSealEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)soundSealEventHandler);
        MAXRANGE = 16;
    }

    @SideOnly(value=Side.CLIENT)
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0016J\u0010\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0006\u001a\n \u0012*\u0004\u0018\u00010\u00180\u0018H\u0016J\u0010\u0010\u0019\u001a\n \u0012*\u0004\u0018\u00010\u001a0\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/wiresegal/naturalpledge/common/block/dendrics/sealing/SoundSealEventHandler$VolumeModSound;", "Lnet/minecraft/client/audio/ISound;", "sound", "volumeMult", "", "(Lnet/minecraft/client/audio/ISound;F)V", "getSound", "()Lnet/minecraft/client/audio/ISound;", "getVolumeMult", "()F", "canRepeat", "", "createAccessor", "Lnet/minecraft/client/audio/SoundEventAccessor;", "handler", "Lnet/minecraft/client/audio/SoundHandler;", "getAttenuationType", "Lnet/minecraft/client/audio/ISound$AttenuationType;", "kotlin.jvm.PlatformType", "getCategory", "Lnet/minecraft/util/SoundCategory;", "getPitch", "getRepeatDelay", "", "Lnet/minecraft/client/audio/Sound;", "getSoundLocation", "Lnet/minecraft/util/ResourceLocation;", "getVolume", "getXPosF", "getYPosF", "getZPosF", "NaturalPledge"})
    public static final class VolumeModSound
    implements ISound {
        @NotNull
        private final ISound sound;
        private final float volumeMult;

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147653_e() {
            return this.sound.func_147653_e() * this.volumeMult;
        }

        public float func_147655_f() {
            return this.sound.func_147655_f();
        }

        public float func_147649_g() {
            return this.sound.func_147649_g();
        }

        public float func_147654_h() {
            return this.sound.func_147654_h();
        }

        public float func_147651_i() {
            return this.sound.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.sound.func_147656_j();
        }

        public Sound func_184364_b() {
            return this.sound.func_184364_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(@Nullable SoundHandler handler2) {
            return this.sound.func_184366_a(handler2);
        }

        public SoundCategory func_184365_d() {
            return this.sound.func_184365_d();
        }

        public ResourceLocation func_147650_b() {
            return this.sound.func_147650_b();
        }

        @NotNull
        public final ISound getSound() {
            return this.sound;
        }

        public final float getVolumeMult() {
            return this.volumeMult;
        }

        public VolumeModSound(@NotNull ISound sound, float volumeMult) {
            Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
            this.sound = sound;
            this.volumeMult = volumeMult;
        }
    }
}

