/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.client.render.tile;

import com.wiresegal.naturalpledge.common.block.BlockEnderBind;
import java.awt.Color;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.RenderHelper;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J@\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/wiresegal/naturalpledge/client/render/tile/RenderTileEnderActuator;", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lcom/wiresegal/naturalpledge/common/block/BlockEnderBind$TileEnderBind;", "()V", "color", "", "getColor", "()[F", "h", "", "getH", "()F", "maxV", "getMaxV", "s", "getS", "ticksToActivate", "", "getTicksToActivate", "()I", "warmupTicks", "getWarmupTicks", "render", "", "te", "x", "", "y", "z", "partialTicks", "destroyStage", "alpha", "NaturalPledge"})
public final class RenderTileEnderActuator
extends TileEntitySpecialRenderer<BlockEnderBind.TileEnderBind> {
    @NotNull
    private final float[] color;
    private final float h;
    private final float s;
    private final float maxV;
    private final int ticksToActivate = 85;
    private final int warmupTicks = 15;

    @NotNull
    public final float[] getColor() {
        return this.color;
    }

    public final float getH() {
        return this.h;
    }

    public final float getS() {
        return this.s;
    }

    public final float getMaxV() {
        return this.maxV;
    }

    public final int getTicksToActivate() {
        return this.ticksToActivate;
    }

    public final int getWarmupTicks() {
        return this.warmupTicks;
    }

    public void render(@NotNull BlockEnderBind.TileEnderBind te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)te), (String)"te");
        if (te.getPlayerName() == null) {
            return;
        }
        World world = te.func_145831_w();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"te.world");
        float v = this.maxV * (float)Math.min((int)Math.max(world.func_82737_E() - te.getTickSet() - (long)this.warmupTicks, 0L), this.ticksToActivate) / (float)this.ticksToActivate;
        if (v == 0.0f) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179091_B();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        Object[] objectArray = new Object[3];
        BlockPos blockPos = te.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"te.pos");
        objectArray[0] = blockPos.func_177958_n();
        BlockPos blockPos2 = te.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"te.pos");
        objectArray[1] = blockPos2.func_177956_o();
        BlockPos blockPos3 = te.func_174877_v();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"te.pos");
        objectArray[2] = blockPos3.func_177952_p();
        long seed = Objects.hash(objectArray);
        int color = Color.HSBtoRGB(this.h, this.s, v);
        RenderHelper.renderStar((int)color, (float)0.05f, (float)0.05f, (float)0.05f, (long)seed);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179091_B();
        GlStateManager.func_179121_F();
    }

    public RenderTileEnderActuator() {
        float[] fArray = Color.RGBtoHSB(BlockEnderBind.Companion.getDEFAULT_COLOR().getRed(), BlockEnderBind.Companion.getDEFAULT_COLOR().getGreen(), BlockEnderBind.Companion.getDEFAULT_COLOR().getBlue(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)fArray, (String)"Color.RGBtoHSB(DEFAULT_C\u2026DEFAULT_COLOR.blue, null)");
        this.color = fArray;
        this.h = this.color[0];
        this.s = this.color[1];
        this.maxV = this.color[2];
        this.ticksToActivate = 85;
        this.warmupTicks = 15;
    }
}

