/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.client.integration.jei.treegrowing;

import com.wiresegal.naturalpledge.api.SaplingVariantRegistry;
import com.wiresegal.naturalpledge.api.sapling.IIridescentSaplingVariant;
import com.wiresegal.naturalpledge.api.sapling.IStackConvertible;
import com.wiresegal.naturalpledge.api.sapling.SaplingGrowthRecipe;
import com.wiresegal.naturalpledge.client.integration.jei.treegrowing.TreeGrowingRecipeJEI;
import com.wiresegal.naturalpledge.common.NaturalPledge;
import com.wiresegal.naturalpledge.common.block.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/wiresegal/naturalpledge/client/integration/jei/treegrowing/TreeGrowingRecipeMaker;", "", "()V", "recipes", "", "Lcom/wiresegal/naturalpledge/client/integration/jei/treegrowing/TreeGrowingRecipeJEI;", "getRecipes", "()Ljava/util/List;", "convertState", "Lnet/minecraft/item/ItemStack;", "state", "Lnet/minecraft/block/state/IBlockState;", "NaturalPledge"})
public final class TreeGrowingRecipeMaker {
    public static final TreeGrowingRecipeMaker INSTANCE;

    @NotNull
    public final List<TreeGrowingRecipeJEI> getRecipes() {
        List out = new ArrayList();
        Set variants2 = (Set)SaplingVariantRegistry.getVariantRegistry().values();
        Iterator<Object> iterator = variants2.iterator();
        while (iterator.hasNext()) {
            IIridescentSaplingVariant variant;
            IIridescentSaplingVariant iIridescentSaplingVariant = variant = (IIridescentSaplingVariant)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)iIridescentSaplingVariant, (String)"variant");
            for (IBlockState state : iIridescentSaplingVariant.getDisplaySoilBlockstates()) {
                IBlockState leaves = variant.getLeaves(state);
                IBlockState wood = variant.getWood(state);
                IBlockState iBlockState = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
                ItemStack soilStack = this.convertState(iBlockState);
                IBlockState iBlockState2 = leaves;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"leaves");
                ItemStack leavesStack = this.convertState(iBlockState2);
                IBlockState iBlockState3 = wood;
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"wood");
                ItemStack woodStack = this.convertState(iBlockState3);
                if (soilStack.func_77973_b() == null || leavesStack.func_77973_b() == null || woodStack.func_77973_b() == null) {
                    NaturalPledge.Companion.getLOGGER().warn("Sapling variant {" + variant + "} has a null stack, skipping. Report this to the modmaker of that mod");
                    continue;
                }
                if (soilStack.func_190926_b() || leavesStack.func_190926_b() || woodStack.func_190926_b()) {
                    NaturalPledge.Companion.getLOGGER().warn("Sapling variant {" + variant + "} has a block without an item, skipping. Report this to the modmaker of that mod");
                    continue;
                }
                out.add(new TreeGrowingRecipeJEI(new ItemStack((Block)ModBlocks.INSTANCE.getIrisSapling()), soilStack, woodStack, leavesStack));
            }
        }
        iterator = SaplingVariantRegistry.getSaplingRecipeRegistry().iterator();
        while (iterator.hasNext()) {
            SaplingGrowthRecipe recipe;
            SaplingGrowthRecipe saplingGrowthRecipe = recipe = (SaplingGrowthRecipe)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)saplingGrowthRecipe, (String)"recipe");
            ItemStack itemStack = saplingGrowthRecipe.getSapling();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"recipe.sapling");
            ItemStack itemStack2 = recipe.getSoil();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"recipe.soil");
            ItemStack itemStack3 = recipe.getWood();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"recipe.wood");
            ItemStack itemStack4 = recipe.getLeaves();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"recipe.leaves");
            out.add(new TreeGrowingRecipeJEI(itemStack, itemStack2, itemStack3, itemStack4));
        }
        return out;
    }

    private final ItemStack convertState(IBlockState state) {
        ItemStack itemStack;
        if (state.func_177230_c() instanceof IStackConvertible) {
            Block block = state.func_177230_c();
            if (block == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.wiresegal.naturalpledge.api.sapling.IStackConvertible");
            }
            ItemStack itemStack2 = ((IStackConvertible)block).itemStackFromState(state);
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"(state.block as IStackCo\u2026itemStackFromState(state)");
        } else {
            itemStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
        }
        return itemStack;
    }

    private TreeGrowingRecipeMaker() {
    }

    static {
        TreeGrowingRecipeMaker treeGrowingRecipeMaker;
        INSTANCE = treeGrowingRecipeMaker = new TreeGrowingRecipeMaker();
    }
}

