/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.client.core;

import com.wiresegal.naturalpledge.common.core.helper.NPLogger;
import com.wiresegal.naturalpledge.common.lib.LibObfuscation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiIngame;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BAClientMethodHandles {
    @Nonnull
    private static final MethodHandle remainingHighlightSetter;

    public static void setRemainingHighlight(@Nonnull GuiIngame gui, int ticks) {
        try {
            remainingHighlightSetter.invokeExact(gui, ticks);
        }
        catch (Throwable t) {
            throw BAClientMethodHandles.propagate(t);
        }
    }

    private static RuntimeException propagate(Throwable t) {
        NPLogger.INSTANCE.severe("Client methodhandle failed!", new Object[0]);
        t.printStackTrace();
        throw new RuntimeException(t);
    }

    static {
        try {
            Field f = ReflectionHelper.findField(GuiIngame.class, (String[])LibObfuscation.GUIINGAME_REMAININGHIGHLIGHTTICKS);
            f.setAccessible(true);
            remainingHighlightSetter = MethodHandles.publicLookup().unreflectSetter(f);
        }
        catch (Throwable t) {
            NPLogger.INSTANCE.severe("Couldn't initialize client methodhandles! Things will be broken!", new Object[0]);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }
}

