/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.api;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.wiresegal.naturalpledge.api.priest.IFocusSpell;
import com.wiresegal.naturalpledge.api.priest.SpellRecipe;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public final class SpellRegistry {
    @Nonnull
    private static final HashBiMap<String, IFocusSpell> spellRegistry = HashBiMap.create();
    @Nonnull
    private static final ArrayList<SpellRecipe> spellRecipeRegistry = Lists.newArrayList();

    @Nonnull
    public static HashBiMap<String, IFocusSpell> getSpellRegistry() {
        return spellRegistry;
    }

    @Nonnull
    public static ArrayList<SpellRecipe> getSpellRecipeRegistry() {
        return spellRecipeRegistry;
    }

    @Nullable
    public static IFocusSpell registerSpell(@Nonnull String name, @Nonnull IFocusSpell spell) {
        return SpellRegistry.registerSpell(name, spell, false);
    }

    @Nullable
    public static IFocusSpell registerSpell(@Nonnull String name, @Nonnull IFocusSpell spell, boolean force) {
        String modId = Loader.instance().activeModContainer().getModId();
        String transformedName = name;
        if (!modId.equals("naturalpledge")) {
            transformedName = modId + ":" + new ResourceLocation(name).func_110623_a();
        }
        if (spellRegistry.containsKey((Object)transformedName) && !force) {
            return null;
        }
        spellRegistry.put((Object)transformedName, (Object)spell);
        return spell;
    }

    @Nonnull
    public static SpellRecipe registerSpellRecipe(@Nonnull SpellRecipe recipe) {
        spellRecipeRegistry.add(recipe);
        return recipe;
    }

    @Nonnull
    public static SpellRecipe registerSpellRecipe(@Nonnull String input, @Nonnull IFocusSpell spell, ItemStack ... output) {
        return SpellRegistry.registerSpellRecipe(new SpellRecipe(input, spell, output));
    }

    @Nullable
    public static IFocusSpell getSpell(@Nonnull String name) {
        return (IFocusSpell)spellRegistry.get((Object)name);
    }

    @Nullable
    public static String getSpellName(@Nonnull IFocusSpell spell) {
        return (String)spellRegistry.inverse().get((Object)spell);
    }
}

