/*
 * Decompiled with CFR 0.152.
 */
package com.wiresegal.naturalpledge.api;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.wiresegal.naturalpledge.api.sapling.IIridescentSaplingVariant;
import com.wiresegal.naturalpledge.api.sapling.SaplingGrowthRecipe;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public final class SaplingVariantRegistry {
    @Nonnull
    private static final HashBiMap<String, IIridescentSaplingVariant> variantRegistry = HashBiMap.create();
    @Nonnull
    private static final ArrayList<SaplingGrowthRecipe> fakeRecipeRegistry = Lists.newArrayList();

    @Nonnull
    public static HashBiMap<String, IIridescentSaplingVariant> getVariantRegistry() {
        return variantRegistry;
    }

    @Nonnull
    public static ArrayList<SaplingGrowthRecipe> getSaplingRecipeRegistry() {
        return fakeRecipeRegistry;
    }

    @Nullable
    public static IIridescentSaplingVariant registerVariant(@Nonnull String name, @Nonnull IIridescentSaplingVariant variant) {
        return SaplingVariantRegistry.registerVariant(name, variant, false);
    }

    @Nullable
    public static IIridescentSaplingVariant registerVariant(@Nonnull String name, @Nonnull IIridescentSaplingVariant variant, boolean force) {
        String modId = Loader.instance().activeModContainer().getModId();
        String transformedName = name;
        if (!modId.equals("naturalpledge")) {
            transformedName = modId + ":" + name;
        }
        if (variantRegistry.containsKey((Object)transformedName) && !force) {
            return null;
        }
        variantRegistry.put((Object)transformedName, (Object)variant);
        return variant;
    }

    @Nullable
    public static SaplingGrowthRecipe registerRecipe(@Nonnull ItemStack sapling, @Nonnull ItemStack soil, @Nonnull ItemStack wood, @Nonnull ItemStack leaves) {
        return SaplingVariantRegistry.registerRecipe(new SaplingGrowthRecipe(sapling, soil, wood, leaves));
    }

    @Nullable
    public static SaplingGrowthRecipe registerRecipe(SaplingGrowthRecipe recipe) {
        fakeRecipeRegistry.add(recipe);
        return recipe;
    }

    @Nullable
    public static IIridescentSaplingVariant getVariant(@Nonnull IBlockState soil) {
        for (IIridescentSaplingVariant variant : variantRegistry.values()) {
            if (!variant.matchesSoil(soil)) continue;
            return variant;
        }
        return null;
    }
}

