/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.Core;
import DummyCore.Core.CoreInitialiser;
import DummyCore.Core.DCMod;
import DummyCore.Utils.Notifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.PatternSyntaxException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ModVersionChecker {
    public static final ArrayList<DCMod> vCheckRequesters = new ArrayList();
    public static final Hashtable<DCMod, String> latestVersions = new Hashtable();
    public static final Hashtable<DCMod, String> modsURIs = new Hashtable();

    public static void addRequest(Class<?> mod, String uri) {
        if (Core.isModRegistered(mod)) {
            DCMod dcmod = Core.getModFromClass(mod);
            vCheckRequesters.add(dcmod);
            modsURIs.put(dcmod, uri);
        } else {
            Notifier.notifyError("[DCVersionChecker]Catched an attempt to add a version check request for a non registered mod!");
        }
    }

    public static void dispatchModChecks() {
        for (int i = 0; i < vCheckRequesters.size(); ++i) {
            ModVersionChecker.requestModVCheck(vCheckRequesters.get(i));
        }
    }

    public static void requestModVCheck(DCMod mod) {
        if (vCheckRequesters.contains(mod)) {
            new ThreadURICheck(mod, modsURIs.get(mod)).start();
        }
    }

    public static void respondToURICheckSuccess(DCMod mod) {
        String currentVersion = mod.version;
        String checkedVersion = latestVersions.get(mod);
        if (ModVersionChecker.isVersionDMValid(checkedVersion) && ModVersionChecker.isVersionDMValid(currentVersion)) {
            int i;
            String[] versions = checkedVersion.split(".");
            String[] cVersions = mod.version.split(".");
            for (i = 0; i < versions.length; ++i) {
                versions[i] = ModVersionChecker.removeButNumbers(versions[i]);
            }
            for (i = 0; i < cVersions.length; ++i) {
                cVersions[i] = ModVersionChecker.removeButNumbers(cVersions[i]);
            }
            for (i = 0; i < 4; ++i) {
                int ii = i;
                if (ii == 0) {
                    ii = 2;
                } else if (ii == 2) {
                    ii = 0;
                }
                String pcurrentVersion = cVersions[ii];
                String pcheckedVersion = versions[ii];
                int current = Integer.parseInt(pcurrentVersion);
                int latest = Integer.parseInt(pcheckedVersion);
                if (current >= latest) continue;
                ModVersionChecker.tryNotifyDMOutdatedMod(mod, checkedVersion, ii);
                break;
            }
        } else {
            int latest;
            String pcurrentVersion = ModVersionChecker.removeButNumbers(currentVersion);
            String pcheckedVersion = ModVersionChecker.removeButNumbers(checkedVersion);
            int current = Integer.parseInt(pcurrentVersion);
            if (current < (latest = Integer.parseInt(pcheckedVersion))) {
                ModVersionChecker.tryNotifySimpleOutdatedMod(mod, checkedVersion);
            }
        }
        vCheckRequesters.remove(mod);
        latestVersions.remove(mod);
        modsURIs.remove(mod);
    }

    public static void tryNotifyDMOutdatedMod(DCMod mod, String latest, int step) {
        EntityPlayer player = CoreInitialiser.proxy.getClientPlayer();
        if (player != null) {
            String steppedString = "";
            switch (step) {
                case 0: {
                    steppedString = String.format("%s is horribly outdated(Your version is %s, latest is %s) has bugs and no longer supported! Update as soon as possible!", mod.ufName, mod.version, latest);
                    break;
                }
                case 1: {
                    steppedString = String.format("%s is outdated(Your version is %s, latest is %s)! Consider updating!", mod.ufName, mod.version, latest);
                    break;
                }
                case 2: {
                    steppedString = String.format("%s is available for another version of the game(Your version is %s, latest is %s)!", mod.ufName, mod.version, latest);
                    break;
                }
                case 3: {
                    steppedString = String.format("%s has a new version available(Your version is %s, latest is %s)!", mod.ufName, mod.version, latest);
                    break;
                }
            }
            player.func_145747_a(new TextComponentString(steppedString).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public static void tryNotifySimpleOutdatedMod(DCMod mod, String latest) {
        EntityPlayer player = CoreInitialiser.proxy.getClientPlayer();
        if (player != null) {
            player.func_145747_a(new TextComponentString(String.format("%s is outdated(Your version is %s, latest is %s)! Consider updating!", mod.ufName, mod.version, latest)).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public static boolean isVersionDMValid(String version) {
        try {
            return version.split(".").length >= 4;
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
            Notifier.notifyError("[DCVersionChecker]" + version + " is not a valid DM version");
            return false;
        }
    }

    public static String removeButNumbers(String s) {
        char[] chars;
        String result = "";
        for (char c : chars = s.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            result = result + c;
        }
        return result;
    }

    public static class ThreadURICheck
    extends Thread {
        public String uristr;
        public DCMod mod;

        public ThreadURICheck(DCMod mod, String uri) {
            super("[DCVercionCheckDaemon]For mod: " + mod.ufName);
            this.setDaemon(true);
            this.setPriority(1);
            this.mod = mod;
            this.uristr = uri;
        }

        @Override
        public void run() {
            try {
                URI uri = new URI(this.uristr);
                InputStream is = uri.toURL().openStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String version = br.readLine();
                latestVersions.put(this.mod, version);
                is.close();
                ModVersionChecker.respondToURICheckSuccess(this.mod);
                this.interrupt();
            }
            catch (URISyntaxException urise) {
                urise.printStackTrace();
                Notifier.notifyErrorCustomMod("[DCVercionCheckDaemon]" + this.mod.ufName, this.uristr + " is not a valid URI!");
                this.interrupt();
            }
            catch (MalformedURLException murle) {
                murle.printStackTrace();
                Notifier.notifyErrorCustomMod("[DCVercionCheckDaemon]" + this.mod.ufName, this.uristr + " is not a valid URL!");
                this.interrupt();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Notifier.notifyErrorCustomMod("[DCVercionCheckDaemon]" + this.mod.ufName, "Couldn't read file at " + this.uristr);
                this.interrupt();
            }
        }
    }
}

