/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.UnformedItemStack;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.oredict.OreIngredient;

public class IngredientUtils {
    public static Ingredient getIngredient(Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)obj).func_77946_l()});
        }
        if (obj instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)obj));
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof UnformedItemStack) {
            return Ingredient.func_193369_a((ItemStack[])((UnformedItemStack)obj).possibleStacks.toArray(new ItemStack[0]));
        }
        if (obj instanceof Item[]) {
            return Ingredient.func_193368_a((Item[])((Item[])obj));
        }
        if (obj instanceof ItemStack[]) {
            return Ingredient.func_193369_a((ItemStack[])((ItemStack[])obj));
        }
        if (obj instanceof Object[]) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            for (Object obj1 : (Object[])obj) {
                Ingredient ingredient = IngredientUtils.getIngredient(obj1);
                if (ingredient.getClass() == Ingredient.class) {
                    vanilla.add(ingredient);
                    continue;
                }
                ingredients.add(ingredient);
            }
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                return Ingredient.field_193370_a;
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients){};
        }
        if (obj instanceof List) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            for (Object obj1 : (List)obj) {
                Ingredient ingredient = IngredientUtils.getIngredient(obj1);
                if (ingredient.getClass() == Ingredient.class) {
                    vanilla.add(ingredient);
                    continue;
                }
                ingredients.add(ingredient);
            }
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                return Ingredient.field_193370_a;
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients){};
        }
        return Ingredient.field_193370_a;
    }

    public static IngredientNBT getIngredientNBT(ItemStack stack) {
        return new IngredientNBT(stack.func_77946_l()){};
    }

    public static Ingredient getIngredientNBT(Object obj) {
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof ItemStack) {
            return IngredientUtils.getIngredientNBT(((ItemStack)obj).func_77946_l());
        }
        if (obj instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)obj));
        }
        if (obj instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof UnformedItemStack) {
            return IngredientUtils.getIngredientNBT(((UnformedItemStack)obj).possibleStacks);
        }
        if (obj instanceof Item[]) {
            return Ingredient.func_193368_a((Item[])((Item[])obj));
        }
        if (obj instanceof Object[]) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            for (Object obj1 : (Object[])obj) {
                Ingredient ingredient = IngredientUtils.getIngredient(obj1);
                if (ingredient.getClass() == Ingredient.class) {
                    vanilla.add(ingredient);
                    continue;
                }
                ingredients.add(ingredient);
            }
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                return Ingredient.field_193370_a;
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients){};
        }
        if (obj instanceof List) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            for (Object obj1 : (List)obj) {
                Ingredient ingredient = IngredientUtils.getIngredient(obj1);
                if (ingredient.getClass() == Ingredient.class) {
                    vanilla.add(ingredient);
                    continue;
                }
                ingredients.add(ingredient);
            }
            if (!vanilla.isEmpty()) {
                ingredients.add(Ingredient.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                return Ingredient.field_193370_a;
            }
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients){};
        }
        return Ingredient.field_193370_a;
    }

    public static ItemStack getStackToDraw(Ingredient ingredient, long time) {
        int size = ingredient.func_193365_a().length;
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        return ingredient.func_193365_a()[(int)(time / 30L) % size];
    }
}

