/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.ExtendedAABB;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class Generator {
    public static final Generator instance = new Generator();
    public World world;
    public boolean isWorking;
    public boolean hasOffset;
    public Coord3D offset;
    public Block setTo;
    public int genMetadata;
    public int flag;

    public static ExtendedAABB centerBB(ExtendedAABB genBox) {
        return ExtendedAABB.fromBounds(genBox.minX - (genBox.maxX - genBox.minX) / 2.0, genBox.minY - (genBox.maxY - genBox.minY) / 2.0, genBox.minZ - (genBox.maxZ - genBox.minZ) / 2.0, genBox.maxX - (genBox.maxX - genBox.minX) / 2.0, genBox.maxY - (genBox.maxY - genBox.minY) / 2.0, genBox.maxZ - (genBox.maxZ - genBox.minZ) / 2.0);
    }

    public static ExtendedAABB normaliseBB(ExtendedAABB genBox) {
        double minX = genBox.minX;
        double minY = genBox.minY;
        double minZ = genBox.minZ;
        double maxX = genBox.maxX;
        double maxY = genBox.maxY;
        double maxZ = genBox.maxZ;
        return ExtendedAABB.fromBounds(maxX < minX ? genBox.maxX : genBox.minX, maxY < minY ? genBox.maxY : genBox.minY, maxZ < minZ ? genBox.maxZ : genBox.minZ, maxX < minX ? genBox.minX : genBox.maxX, maxY < minY ? genBox.minY : genBox.maxY, maxZ < minZ ? genBox.minZ : genBox.maxZ);
    }

    public ArrayList<Coord3D> getBlocksOfType(ExtendedAABB genBox) {
        this.gen();
        this.prepareBB(genBox);
        ArrayList<Coord3D> lst = new ArrayList<Coord3D>();
        for (int x = MathHelper.func_76128_c((double)genBox.minX); x <= MathHelper.func_76128_c((double)genBox.maxX); ++x) {
            for (int y = MathHelper.func_76128_c((double)genBox.minY); y <= MathHelper.func_76128_c((double)genBox.maxY); ++y) {
                for (int z = MathHelper.func_76128_c((double)genBox.minZ); z <= MathHelper.func_76128_c((double)genBox.maxZ); ++z) {
                    if (this.world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != this.setTo || this.world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176201_c(this.world.func_180495_p(new BlockPos(x, y, z))) != this.genMetadata && this.genMetadata != Short.MAX_VALUE) continue;
                    Coord3D c = new Coord3D(x, y, z);
                    lst.add(c);
                }
            }
        }
        this.restoreBB(genBox);
        return lst;
    }

    public void setOffset(Coord3D coord) {
        this.offset = coord;
        this.hasOffset = true;
    }

    public void setOffset(int x, int y, int z) {
        this.offset = new Coord3D(x, y, z);
        this.hasOffset = true;
    }

    public void startWorldgen(World world) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Worldgen on CLIENT side is not allowed!");
        }
        if (this.isWorking) {
            throw new IllegalStateException("Already generating!");
        }
        this.offset = null;
        this.hasOffset = false;
        this.isWorking = true;
        this.world = world;
        this.setTo = Blocks.field_150350_a;
        this.genMetadata = 0;
        this.flag = 2;
    }

    public void endWorldgen() {
        if (!this.isWorking) {
            throw new IllegalStateException("Not generating!");
        }
        this.offset = null;
        this.isWorking = false;
        this.world = null;
        this.hasOffset = false;
        this.setTo = null;
        this.genMetadata = 0;
        this.flag = 0;
    }

    public void setFlag(int i) {
        this.gen();
        this.flag = i;
    }

    public boolean gen() {
        if (!this.isWorking) {
            throw new IllegalStateException("Can't worlgen if not generating!");
        }
        if (this.world.field_72995_K) {
            throw new IllegalArgumentException("Worldgen on CLIENT side is not allowed!");
        }
        return this.isWorking;
    }

    public void restoreBB(ExtendedAABB genBox) {
        this.gen();
        if (this.hasOffset) {
            genBox.minX -= (double)this.offset.x;
            genBox.minY -= (double)this.offset.y;
            genBox.minZ -= (double)this.offset.z;
            genBox.maxX -= (double)this.offset.x;
            genBox.maxY -= (double)this.offset.y;
            genBox.maxZ -= (double)this.offset.z;
        }
    }

    public void prepareBB(ExtendedAABB genBox) {
        this.gen();
        if (this.hasOffset) {
            genBox.minX += (double)this.offset.x;
            genBox.minY += (double)this.offset.y;
            genBox.minZ += (double)this.offset.z;
            genBox.maxX += (double)this.offset.x;
            genBox.maxY += (double)this.offset.y;
            genBox.maxZ += (double)this.offset.z;
        }
    }

    public void setBlock(Block b) {
        this.gen();
        this.setTo = b;
        this.genMetadata = 0;
    }

    public void setMeta(int i) {
        this.gen();
        this.genMetadata = i;
    }

    public void randomiseCuboid(ExtendedAABB genBox, Pair<Block, Integer> ... pairs) {
        this.gen();
        this.prepareBB(genBox);
        int x = MathHelper.func_76128_c((double)genBox.minX);
        int y = MathHelper.func_76128_c((double)genBox.minY);
        int z = MathHelper.func_76128_c((double)genBox.minZ);
        int eX = MathHelper.func_76128_c((double)genBox.maxX);
        int eY = MathHelper.func_76128_c((double)genBox.maxY);
        int eZ = MathHelper.func_76128_c((double)genBox.maxZ);
        for (int dx = x; dx <= eX; ++dx) {
            for (int dy = y; dy <= eY; ++dy) {
                for (int dz = z; dz <= eZ; ++dz) {
                    int i = this.world.field_73012_v.nextInt(pairs.length);
                    if (this.world.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c() != this.setTo) continue;
                    this.world.func_180501_a(new BlockPos(dx, dy, dz), ((Block)pairs[i].getLeft()).func_176203_a(((Integer)pairs[i].getRight()).intValue()), this.flag);
                }
            }
        }
        this.restoreBB(genBox);
    }

    public void addFullSphere(ExtendedAABB genBox) {
        this.gen();
        genBox = Generator.normaliseBB(genBox);
        this.prepareBB(genBox);
        double radiusX = (genBox.maxX - genBox.minX) / 2.0;
        double radiusY = (genBox.maxY - genBox.minY) / 2.0;
        double radiusZ = (genBox.maxZ - genBox.minZ) / 2.0;
        int dx = MathHelper.func_76128_c((double)(genBox.minX + radiusX));
        int dy = MathHelper.func_76128_c((double)(genBox.minY + radiusY));
        int dz = MathHelper.func_76128_c((double)(genBox.minZ + radiusZ));
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        boolean filled = true;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = Generator.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && Generator.lengthSq(nextXn, yn, zn) <= 1.0 && Generator.lengthSq(xn, nextYn, zn) <= 1.0 && Generator.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz - z)));
                }
            }
        }
        this.restoreBB(genBox);
    }

    public void addHollowCylinder(ExtendedAABB genBox) {
        this.gen();
        genBox = Generator.normaliseBB(genBox);
        this.prepareBB(genBox);
        double radiusX = (genBox.maxX - genBox.minX) / 2.0;
        double height = genBox.maxY - genBox.minY;
        double radiusZ = (genBox.maxZ - genBox.minZ) / 2.0;
        int dx = MathHelper.func_76128_c((double)(genBox.minX + radiusX));
        int dy = MathHelper.func_76128_c((double)genBox.minY);
        int dz = MathHelper.func_76128_c((double)(genBox.minZ + radiusZ));
        boolean filled = false;
        radiusX += 0.5;
        radiusZ += 0.5;
        if (height == 0.0) {
            return;
        }
        if (height < 0.0) {
            height = -height;
            dy = MathHelper.func_76128_c((double)(-height));
        }
        if (dy < 0) {
            dy = 0;
        } else if ((double)dy + height - 1.0 > (double)this.world.func_72940_L()) {
            height = this.world.func_72940_L() - dy + 1;
        }
        double invRadiusX = 1.0 / radiusX;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= ceilRadiusZ; ++z) {
                double zn = nextZn;
                nextZn = (double)(z + 1) * invRadiusZ;
                double distanceSq = Generator.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (!filled && Generator.lengthSq(nextXn, zn) <= 1.0 && Generator.lengthSq(xn, nextZn) <= 1.0) continue;
                int y = 0;
                while ((double)y < height) {
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    ++y;
                }
            }
        }
        this.restoreBB(genBox);
    }

    public void addFullCylinder(ExtendedAABB genBox) {
        this.gen();
        genBox = Generator.normaliseBB(genBox);
        this.prepareBB(genBox);
        double radiusX = (genBox.maxX - genBox.minX) / 2.0;
        double height = genBox.maxY - genBox.minY;
        double radiusZ = (genBox.maxZ - genBox.minZ) / 2.0;
        int dx = MathHelper.func_76128_c((double)(genBox.minX + radiusX));
        int dy = MathHelper.func_76128_c((double)genBox.minY);
        int dz = MathHelper.func_76128_c((double)(genBox.minZ + radiusZ));
        boolean filled = true;
        radiusX += 0.5;
        radiusZ += 0.5;
        if (height == 0.0) {
            return;
        }
        if (height < 0.0) {
            height = -height;
            dy = MathHelper.func_76128_c((double)(-height));
        }
        if (dy < 0) {
            dy = 0;
        } else if ((double)dy + height - 1.0 > (double)this.world.func_72940_L()) {
            height = this.world.func_72940_L() - dy + 1;
        }
        double invRadiusX = 1.0 / radiusX;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= ceilRadiusZ; ++z) {
                double zn = nextZn;
                nextZn = (double)(z + 1) * invRadiusZ;
                double distanceSq = Generator.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (!filled && Generator.lengthSq(nextXn, zn) <= 1.0 && Generator.lengthSq(xn, nextZn) <= 1.0) continue;
                int y = 0;
                while ((double)y < height) {
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    ++y;
                }
            }
        }
        this.restoreBB(genBox);
    }

    public void addHollowSphere(ExtendedAABB genBox) {
        this.gen();
        genBox = Generator.normaliseBB(genBox);
        this.prepareBB(genBox);
        double radiusX = (genBox.maxX - genBox.minX) / 2.0;
        double radiusY = (genBox.maxY - genBox.minY) / 2.0;
        double radiusZ = (genBox.maxZ - genBox.minZ) / 2.0;
        int dx = MathHelper.func_76128_c((double)(genBox.minX + radiusX));
        int dy = MathHelper.func_76128_c((double)(genBox.minY + radiusY));
        int dz = MathHelper.func_76128_c((double)(genBox.minZ + radiusZ));
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        boolean filled = false;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = Generator.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && Generator.lengthSq(nextXn, yn, zn) <= 1.0 && Generator.lengthSq(xn, nextYn, zn) <= 1.0 && Generator.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz + z)));
                    this.block(MathHelper.func_76141_d((float)(dx + x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy + y)), MathHelper.func_76141_d((float)(dz - z)));
                    this.block(MathHelper.func_76141_d((float)(dx - x)), MathHelper.func_76141_d((float)(dy - y)), MathHelper.func_76141_d((float)(dz - z)));
                }
            }
        }
        this.restoreBB(genBox);
    }

    public void addWallsCuboid(ExtendedAABB genBox) {
        this.gen();
        this.addCuboid(ExtendedAABB.fromBounds(genBox.minX, genBox.minY, genBox.minZ, genBox.maxX, genBox.minY, genBox.maxZ));
        this.addCuboid(ExtendedAABB.fromBounds(genBox.minX, genBox.maxY, genBox.minZ, genBox.maxX, genBox.maxY, genBox.maxZ));
        this.addCuboid(ExtendedAABB.fromBounds(genBox.minX, genBox.minY, genBox.minZ, genBox.minX, genBox.maxY, genBox.maxZ));
        this.addCuboid(ExtendedAABB.fromBounds(genBox.maxX, genBox.minY, genBox.minZ, genBox.maxX, genBox.maxY, genBox.maxZ));
        this.addCuboid(ExtendedAABB.fromBounds(genBox.minX, genBox.minY, genBox.minZ, genBox.maxX, genBox.maxY, genBox.minZ));
        this.addCuboid(ExtendedAABB.fromBounds(genBox.minX, genBox.minY, genBox.maxZ, genBox.maxX, genBox.maxY, genBox.maxZ));
    }

    public boolean block(int x, int y, int z) {
        this.gen();
        return this.world.func_180501_a(new BlockPos(x, y, z), this.setTo.func_176203_a(this.genMetadata), this.flag);
    }

    public void addCuboid(ExtendedAABB genBox) {
        this.gen();
        this.prepareBB(genBox);
        int x = MathHelper.func_76128_c((double)genBox.minX);
        int y = MathHelper.func_76128_c((double)genBox.minY);
        int z = MathHelper.func_76128_c((double)genBox.minZ);
        int eX = MathHelper.func_76128_c((double)genBox.maxX);
        int eY = MathHelper.func_76128_c((double)genBox.maxY);
        int eZ = MathHelper.func_76128_c((double)genBox.maxZ);
        this.addCuboid(x, y, z, eX, eY, eZ);
        this.restoreBB(genBox);
    }

    public void addCuboid(int x, int y, int z, int eX, int eY, int eZ) {
        this.gen();
        for (int dx = x; dx <= eX; ++dx) {
            for (int dy = y; dy <= eY; ++dy) {
                for (int dz = z; dz <= eZ; ++dz) {
                    this.block(dx, dy, dz);
                }
            }
        }
    }

    private static double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    private static double lengthSq(double x, double z) {
        return x * x + z * z;
    }
}

