/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.DummyPortalGenerator;
import DummyCore.Utils.DummyTeleporter;
import DummyCore.Utils.MiscUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Hashtable;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DummyPortalHandler {
    public static final Hashtable<Block, PortalBlockData> BLOCK_DATA = new Hashtable();
    public static final Hashtable<UUID, PortalPlayerData> PLAYER_DATA = new Hashtable();
    public static final Int2ObjectMap<DummyTeleporter> TO_TELEPORTERS = new Int2ObjectOpenHashMap();
    public static final Int2ObjectMap<DummyTeleporter> RETURN_TELEPORTERS = new Int2ObjectOpenHashMap();

    public static void registerPortal(Block block, int toDim, int retDim, int tpTicks, boolean checkBelow, DummyPortalGenerator generator, ResourceLocation overlayLocation, int color) {
        BLOCK_DATA.put(block, new PortalBlockData(toDim, retDim, tpTicks, checkBelow, generator, overlayLocation, color));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        for (PortalBlockData data : BLOCK_DATA.values()) {
            data.overlayTexture = event.getMap().func_174942_a(data.overlayLocation);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PortalBlockData blockData;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (!PLAYER_DATA.containsKey(MiscUtils.getUUIDFromPlayer(event.player))) {
            PLAYER_DATA.put(MiscUtils.getUUIDFromPlayer(event.player), new PortalPlayerData());
        }
        PortalPlayerData playerData = PLAYER_DATA.get(MiscUtils.getUUIDFromPlayer(event.player));
        BlockPos pos = new BlockPos(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v);
        Block block = event.player.func_130014_f_().func_180495_p(pos).func_177230_c();
        BlockPos posDown = new BlockPos(event.player.field_70165_t, event.player.field_70163_u - 1.0, event.player.field_70161_v);
        Block blockDown = event.player.func_130014_f_().func_180495_p(posDown).func_177230_c();
        if (BLOCK_DATA.containsKey(blockDown)) {
            blockData = BLOCK_DATA.get(blockDown);
            if (blockData.checkBelow) {
                int toDim;
                playerData.portalUsing = blockData;
                int n = toDim = event.player.field_71093_bK == blockData.toDim ? blockData.retDim : blockData.toDim;
                if ((playerData.portalTicks == blockData.tpTicks || event.player.field_71075_bZ.field_75098_d) && !playerData.hasFinished) {
                    DummyPortalHandler.transferEntityToDimension(blockData, (Entity)event.player, toDim, true);
                    playerData.hasFinished = true;
                }
                ++playerData.portalTicks;
                return;
            }
        }
        if (BLOCK_DATA.containsKey(block)) {
            int toDim;
            playerData.portalUsing = blockData = BLOCK_DATA.get(block);
            int n = toDim = event.player.field_71093_bK == blockData.toDim ? blockData.retDim : blockData.toDim;
            if ((playerData.portalTicks == blockData.tpTicks || event.player.field_71075_bZ.field_75098_d) && !playerData.hasFinished) {
                DummyPortalHandler.transferEntityToDimension(blockData, (Entity)event.player, toDim, true);
                playerData.hasFinished = true;
            }
            ++playerData.portalTicks;
            return;
        }
        playerData.portalUsing = null;
        playerData.portalTicks = 0;
        playerData.hasFinished = false;
    }

    public static void transferEntityToDimension(Entity entityIn) {
        PortalBlockData blockData;
        if (entityIn instanceof EntityPlayer) {
            return;
        }
        BlockPos pos = new BlockPos(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
        Block block = entityIn.func_130014_f_().func_180495_p(pos).func_177230_c();
        BlockPos posDown = new BlockPos(entityIn.field_70165_t, entityIn.field_70163_u - 1.0, entityIn.field_70161_v);
        Block blockDown = entityIn.func_130014_f_().func_180495_p(posDown).func_177230_c();
        if (BLOCK_DATA.containsKey(blockDown)) {
            blockData = BLOCK_DATA.get(blockDown);
            if (blockData.checkBelow && entityIn.field_71088_bW == 0) {
                entityIn.field_71088_bW = entityIn.func_82147_ab();
                int toDim = entityIn.field_71093_bK == blockData.toDim ? blockData.retDim : blockData.toDim;
                DummyPortalHandler.transferEntityToDimension(blockData, entityIn, toDim, false);
                return;
            }
        }
        if (BLOCK_DATA.containsKey(block) && entityIn.field_71088_bW == 0) {
            entityIn.field_71088_bW = entityIn.func_82147_ab();
            blockData = BLOCK_DATA.get(block);
            int toDim = entityIn.field_71093_bK == blockData.toDim ? blockData.retDim : blockData.toDim;
            DummyPortalHandler.transferEntityToDimension(blockData, entityIn, toDim, false);
        }
    }

    private static void transferEntityToDimension(PortalBlockData blockData, Entity entityIn, int toDim, boolean isPlayer) {
        DummyTeleporter teleporter;
        WorldServer server;
        if (entityIn.func_130014_f_().field_72995_K) {
            return;
        }
        MinecraftServer mcServer = entityIn.func_184102_h();
        if (!TO_TELEPORTERS.containsKey(blockData.toDim)) {
            server = mcServer.func_71218_a(blockData.toDim);
            TO_TELEPORTERS.put(blockData.toDim, (Object)new DummyTeleporter(server, blockData.generator, true));
        }
        if (!RETURN_TELEPORTERS.containsKey(blockData.toDim)) {
            server = mcServer.func_71218_a(blockData.retDim);
            RETURN_TELEPORTERS.put(blockData.toDim, (Object)new DummyTeleporter(server, blockData.generator, true));
        }
        PlayerList list = entityIn.func_184102_h().func_184103_al();
        DummyTeleporter dummyTeleporter = teleporter = toDim == blockData.toDim ? (DummyTeleporter)((Object)TO_TELEPORTERS.get(blockData.toDim)) : (DummyTeleporter)((Object)RETURN_TELEPORTERS.get(blockData.toDim));
        if (isPlayer) {
            DummyPortalHandler.transferPlayerToDimension((EntityPlayerMP)entityIn, toDim, teleporter);
        } else {
            DummyPortalHandler.transferEntityToWorld(entityIn, entityIn.field_71093_bK, mcServer.func_71218_a(entityIn.field_71093_bK), mcServer.func_71218_a(toDim), teleporter);
        }
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimensionIn, Teleporter teleporter) {
        int i = player.field_71093_bK;
        MinecraftServer mcServer = player.field_71133_b;
        PlayerList list = mcServer.func_184103_al();
        WorldServer worldserver = mcServer.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimensionIn;
        WorldServer worldserver1 = mcServer.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, worldserver1.func_175659_aa(), worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        list.func_187243_f(player);
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        DummyPortalHandler.transferEntityToWorld((Entity)player, i, worldserver, worldserver1, teleporter);
        list.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
        list.func_72354_b(player, worldserver1);
        list.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, i, dimensionIn);
    }

    public static void transferEntityToWorld(Entity entityIn, int lastDimension, WorldServer oldWorldIn, WorldServer toWorldIn, Teleporter teleporter) {
        WorldProvider pOld = oldWorldIn.field_73011_w;
        WorldProvider pNew = toWorldIn.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = entityIn.field_70165_t * moveFactor;
        double d1 = entityIn.field_70161_v * moveFactor;
        float f = entityIn.field_70177_z;
        oldWorldIn.field_72984_F.func_76320_a("placing");
        d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
        d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
        if (entityIn.func_70089_S()) {
            entityIn.func_70012_b(d0, entityIn.field_70163_u, d1, entityIn.field_70177_z, entityIn.field_70125_A);
            teleporter.func_180266_a(entityIn, f);
            toWorldIn.func_72838_d(entityIn);
            toWorldIn.func_72866_a(entityIn, false);
        }
        oldWorldIn.field_72984_F.func_76319_b();
        entityIn.func_70029_a((World)toWorldIn);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int k = event.getResolution().func_78326_a();
            int l = event.getResolution().func_78328_b();
            if (PLAYER_DATA.containsKey(MiscUtils.getUUIDFromPlayer((EntityPlayer)player))) {
                PortalPlayerData playerData = PLAYER_DATA.get(MiscUtils.getUUIDFromPlayer((EntityPlayer)player));
                if (playerData.portalUsing != null) {
                    PortalBlockData blockData = playerData.portalUsing;
                    TextureAtlasSprite iicon = blockData.overlayTexture;
                    int color = blockData.color;
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179131_c((float)((float)(color & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)(blockData.tpTicks != 0 ? (float)playerData.portalTicks / (float)blockData.tpTicks : 1.0f));
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    float f1 = iicon.func_94209_e();
                    float f2 = iicon.func_94206_g();
                    float f3 = iicon.func_94212_f();
                    float f4 = iicon.func_94210_h();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder vertexbuffer = tessellator.func_178180_c();
                    vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    vertexbuffer.func_181662_b(0.0, (double)l, -90.0).func_187315_a((double)f1, (double)f4).func_181675_d();
                    vertexbuffer.func_181662_b((double)k, (double)l, -90.0).func_187315_a((double)f3, (double)f4).func_181675_d();
                    vertexbuffer.func_181662_b((double)k, 0.0, -90.0).func_187315_a((double)f3, (double)f2).func_181675_d();
                    vertexbuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)f1, (double)f2).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    public static class PortalPlayerData {
        public int portalTicks;
        public PortalBlockData portalUsing;
        public boolean hasFinished;
    }

    public static class PortalBlockData {
        public final int toDim;
        public final int retDim;
        public final int tpTicks;
        public final int color;
        public final boolean checkBelow;
        public final DummyPortalGenerator generator;
        public final ResourceLocation overlayLocation;
        public TextureAtlasSprite overlayTexture;

        public PortalBlockData(int toDim, int retDim, int tpTicks, boolean checkBelow, DummyPortalGenerator generator, ResourceLocation overlayLocation, int color) {
            this.toDim = toDim;
            this.retDim = retDim;
            this.tpTicks = tpTicks;
            this.checkBelow = checkBelow;
            this.generator = generator;
            this.overlayLocation = overlayLocation;
            this.color = color;
        }
    }
}

