/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.Core;
import DummyCore.Core.CoreInitialiser;
import DummyCore.Core.DCMod;
import DummyCore.Utils.TessellatorWrapper;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class DCParticleEngine {
    public static final Hashtable<LayerEntry, ArrayList<Particle>> particles = new Hashtable();
    public static final ArrayList<ParticleTicket> tickets = new ArrayList();
    public static final Hashtable<DCMod, ParticleTicket> ticketData = new Hashtable();
    public static final ArrayList<Particle> allParticles = new ArrayList();

    public static ParticleTicket obtainTicketForMod(Class<?> mod) {
        if (Core.isModRegistered(mod)) {
            return DCParticleEngine.obtainTicketForMod(Core.getModFromClass(mod));
        }
        return null;
    }

    public static ParticleTicket obtainTicketForMod(DCMod mod) {
        if (ticketData.containsKey(mod)) {
            return ticketData.get(mod);
        }
        return DCParticleEngine.createTicket(mod);
    }

    public static ParticleTicket createTicket(DCMod mod) {
        ParticleTicket ticket = new ParticleTicket(mod).setMaxParticles(1000);
        tickets.add(ticket);
        ticketData.put(mod, ticket);
        return ticket;
    }

    public static void addParticle(LayerEntry layer, Particle particle) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return;
        }
        if (!particles.containsKey(layer)) {
            particles.put(layer, new ArrayList());
        }
        int currentParticlesForLayer = particles.get(layer).size();
        int currentParticlesForMod = 0;
        for (LayerEntry le : layer.owner.layers) {
            if (!particles.containsKey(le)) continue;
            currentParticlesForMod += particles.get(le).size();
        }
        if (currentParticlesForLayer >= layer.maxParticlesFor || currentParticlesForMod >= layer.owner.maxParticlesForMod && layer.owner.maxParticlesForMod != -1) {
            return;
        }
        allParticles.add(particle);
        particles.get(layer).add(particle);
    }

    public static void tick() {
        for (int i = 0; i < allParticles.size(); ++i) {
            Particle particle = allParticles.get(i);
            if (!particle.func_187113_k()) {
                allParticles.remove(i);
                continue;
            }
            particle.func_189213_a();
        }
    }

    public static void draw(float partialTicks) {
        boolean alpha = GL11.glIsEnabled((int)3008);
        boolean blend = GL11.glIsEnabled((int)3042);
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)false);
        for (ParticleTicket ticket : tickets) {
            for (LayerEntry layer : ticket.layers) {
                if (!particles.containsKey(layer)) continue;
                ArrayList<Particle> par = particles.get(layer);
                GlStateManager.func_179094_E();
                if (MinecraftForge.EVENT_BUS.post((Event)new LayerEntry.LayerEvent.Pre(layer))) {
                    GlStateManager.func_179121_F();
                    continue;
                }
                if (layer.blend) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)layer.blend_src, (int)layer.blend_dst);
                }
                if (layer.alpha) {
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179092_a((int)layer.alpha_index, (float)layer.alpha_func);
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(layer.texture);
                EntityPlayerSP renderViewEntity = Minecraft.func_71410_x().field_71439_g;
                float rotationViewX = ActiveRenderInfo.func_178808_b();
                float rotationViewZ = ActiveRenderInfo.func_178803_d();
                float rotationViewXY = ActiveRenderInfo.func_178807_f();
                float rotationViewYZ = ActiveRenderInfo.func_178805_e();
                float rotationViewXZ = ActiveRenderInfo.func_178809_c();
                Particle.field_70556_an = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
                Particle.field_70554_ao = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
                Particle.field_70555_ap = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
                Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (int i = 0; i < par.size(); ++i) {
                    Particle particle = par.get(i);
                    if (!particle.func_187113_k()) {
                        par.remove(i);
                        continue;
                    }
                    try {
                        particle.func_180434_a(Tessellator.func_178181_a().func_178180_c(), (Entity)CoreInitialiser.proxy.getClientPlayer(), partialTicks, rotationViewX, rotationViewXZ, rotationViewZ, rotationViewYZ, rotationViewXY);
                        continue;
                    }
                    catch (Exception e) {
                        particle.func_187112_i();
                        e.printStackTrace();
                    }
                }
                TessellatorWrapper.getInstance().draw();
                if (layer.blend) {
                    GlStateManager.func_179084_k();
                }
                if (layer.alpha) {
                    GlStateManager.func_179118_c();
                }
                MinecraftForge.EVENT_BUS.post((Event)new LayerEntry.LayerEvent.Post(layer));
                GlStateManager.func_179121_F();
            }
        }
        if (alpha) {
            GlStateManager.func_179141_d();
        }
        if (blend) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DCParticleEngine.tick();
        }
    }

    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        DCParticleEngine.draw(event.getPartialTicks());
    }

    public static class ParticleTicket {
        public DCMod owner;
        public final ArrayList<LayerEntry> layers = new ArrayList();
        public int maxParticlesForMod;

        public ParticleTicket(DCMod mod) {
            this.owner = mod;
        }

        public ParticleTicket setMaxParticles(int i) {
            this.maxParticlesForMod = i;
            return this;
        }

        public ParticleTicket appendLayer(LayerEntry layer) {
            this.layers.add(layer);
            layer.owner = this;
            return this;
        }
    }

    public static class LayerEntry {
        public ParticleTicket owner;
        public ResourceLocation texture;
        public boolean blend;
        public boolean alpha;
        public int blend_src;
        public int blend_dst;
        public int alpha_index;
        public float alpha_func;
        public int maxParticlesFor;

        public LayerEntry(ResourceLocation loc) {
            this.texture = loc;
        }

        public LayerEntry enableBlend() {
            this.blend = true;
            return this;
        }

        public LayerEntry enableAlpha() {
            this.alpha = true;
            return this;
        }

        public LayerEntry blendFunc(int i, int j) {
            this.blend_src = i;
            this.blend_dst = j;
            return this;
        }

        public LayerEntry alphaFunc(int i, float f) {
            this.alpha_index = i;
            this.alpha_func = f;
            return this;
        }

        public LayerEntry setMaxParticles(int i) {
            this.maxParticlesFor = i;
            return this;
        }

        public static class LayerEvent
        extends Event {
            public final LayerEntry layer;

            public LayerEvent(LayerEntry par1) {
                this.layer = par1;
            }

            public static class Post
            extends LayerEvent {
                public Post(LayerEntry par1) {
                    super(par1);
                }
            }

            @Cancelable
            public static class Pre
            extends LayerEvent {
                public Pre(LayerEntry par1) {
                    super(par1);
                }
            }
        }
    }
}

