/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.ExtendedAABB;
import DummyCore.Utils.PrimitiveUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompoundAABB {
    public ArrayList<ExtendedAABB> bounds = new ArrayList();

    public CompoundAABB(ExtendedAABB ... aabbs) {
        this.bounds.addAll(PrimitiveUtils.listOf(aabbs));
    }

    public CompoundAABB concat(ExtendedAABB aabb) {
        this.bounds.add(aabb);
        return this;
    }

    public CompoundAABB expand(int mx, int my, int mz, int max, int may, int maz) {
        CompoundAABB newAabb = new CompoundAABB(new ExtendedAABB[0]);
        newAabb.bounds.addAll(this.bounds);
        for (ExtendedAABB eab : newAabb.bounds) {
            eab.minX -= (double)mx;
            eab.minY -= (double)my;
            eab.minZ -= (double)mz;
            eab.maxX += (double)mx;
            eab.maxY += (double)my;
            eab.maxZ += (double)mz;
        }
        return newAabb;
    }

    public void replace(World worldIn, Block replace, Block to) {
        ArrayList<String> beenTo = new ArrayList<String>(128);
        for (ExtendedAABB eab : this.bounds) {
            int dx = (int)eab.minX;
            while ((double)dx <= eab.maxX) {
                int dy = (int)eab.minY;
                while ((double)dy <= eab.maxY) {
                    int dz = (int)eab.minZ;
                    while ((double)dz <= eab.maxZ) {
                        if (!beenTo.contains(dx + "|" + dy + "|" + dz)) {
                            beenTo.add(dx + "|" + dy + "|" + dz);
                            Block b = worldIn.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                            if (b.equals(replace)) {
                                worldIn.func_175656_a(new BlockPos(dx, dy, dz), to.func_176223_P());
                            }
                        }
                        ++dz;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        beenTo = null;
    }

    public void fill(World worldIn, Block fillWith) {
        ArrayList<String> beenTo = new ArrayList<String>(128);
        for (ExtendedAABB eab : this.bounds) {
            int dx = (int)eab.minX;
            while ((double)dx <= eab.maxX) {
                int dy = (int)eab.minY;
                while ((double)dy <= eab.maxY) {
                    int dz = (int)eab.minZ;
                    while ((double)dz <= eab.maxZ) {
                        if (!beenTo.contains(dx + "|" + dy + "|" + dz)) {
                            beenTo.add(dx + "|" + dy + "|" + dz);
                            if (worldIn.func_175623_d(new BlockPos(dx, dy, dz))) {
                                worldIn.func_175656_a(new BlockPos(dx, dy, dz), fillWith.func_176223_P());
                            }
                        }
                        ++dz;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        beenTo = null;
    }

    public int count(World worldIn, Block ... blocks) {
        int counted = 0;
        ArrayList<String> beenTo = new ArrayList<String>(128);
        for (ExtendedAABB eab : this.bounds) {
            int dx = (int)eab.minX;
            while ((double)dx <= eab.maxX) {
                int dy = (int)eab.minY;
                while ((double)dy <= eab.maxY) {
                    int dz = (int)eab.minZ;
                    while ((double)dz <= eab.maxZ) {
                        if (!beenTo.contains(dx + "|" + dy + "|" + dz)) {
                            beenTo.add(dx + "|" + dy + "|" + dz);
                            Block b = worldIn.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                            if (PrimitiveUtils.checkArray(blocks, b)) {
                                ++counted;
                            }
                        }
                        ++dz;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        beenTo = null;
        return counted;
    }

    public static CompoundAABB of(ExtendedAABB ... aabbs) {
        return new CompoundAABB(aabbs);
    }
}

