/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public class BiPredicates {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');

    private BiPredicates() {
    }

    public static <T, U> BiPredicate<T, U> alwaysTrue() {
        return ObjectBiPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    public static <T, U> BiPredicate<T, U> alwaysFalse() {
        return ObjectBiPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    public static <T, U> BiPredicate<T, U> not(BiPredicate<T, U> predicate) {
        return new NotBiPredicate<T, U>(predicate);
    }

    public static <T, U> BiPredicate<T, U> and(Iterable<? extends BiPredicate<? super T, ? super U>> components) {
        return new AndBiPredicate(BiPredicates.defensiveCopy(components));
    }

    public static <T, U> BiPredicate<T, U> and(BiPredicate<? super T, ? super U> ... components) {
        return new OrBiPredicate(BiPredicates.defensiveCopy(components));
    }

    public static <T, U> BiPredicate<T, U> and(BiPredicate<? super T, ? super U> first, BiPredicate<? super T, ? super U> second) {
        return new OrBiPredicate(BiPredicates.asList((BiPredicate)Preconditions.checkNotNull(first), (BiPredicate)Preconditions.checkNotNull(second)));
    }

    public static <T, U> BiPredicate<T, U> or(Iterable<? extends BiPredicate<? super T, ? super U>> components) {
        return new OrBiPredicate(BiPredicates.defensiveCopy(components));
    }

    public static <T, U> BiPredicate<T, U> or(BiPredicate<? super T, ? super U> ... components) {
        return new OrBiPredicate(BiPredicates.defensiveCopy(components));
    }

    public static <T, U> BiPredicate<T, U> or(BiPredicate<? super T, ? super U> first, BiPredicate<? super T, ? super U> second) {
        return new OrBiPredicate(BiPredicates.asList((BiPredicate)Preconditions.checkNotNull(first), (BiPredicate)Preconditions.checkNotNull(second)));
    }

    private static <T, U> List<BiPredicate<? super T, ? super U>> asList(BiPredicate<? super T, ? super U> first, BiPredicate<? super T, ? super U> second) {
        return Arrays.asList(first, second);
    }

    private static <T> List<T> defensiveCopy(T ... array) {
        return BiPredicates.defensiveCopy(Arrays.asList(array));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (T element : iterable) {
            list.add(Preconditions.checkNotNull(element));
        }
        return list;
    }

    private static class OrBiPredicate<T, U>
    implements BiPredicate<T, U> {
        private final List<? extends BiPredicate<? super T, ? super U>> components;

        private OrBiPredicate(List<? extends BiPredicate<? super T, ? super U>> components) {
            this.components = components;
        }

        @Override
        public boolean test(T t, U u) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.components.get(i).test(t, u)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.components.hashCode() + 87855567;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof OrBiPredicate) {
                OrBiPredicate that = (OrBiPredicate)obj;
                return this.components.equals(that.components);
            }
            return false;
        }

        public String toString() {
            return "BiPredicates.or(" + COMMA_JOINER.join(this.components) + ")";
        }
    }

    private static class AndBiPredicate<T, U>
    implements BiPredicate<T, U> {
        private final List<? extends BiPredicate<? super T, ? super U>> components;

        private AndBiPredicate(List<? extends BiPredicate<? super T, ? super U>> components) {
            this.components = components;
        }

        @Override
        public boolean test(T t, U u) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.components.get(i).test(t, u)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.components.hashCode() + 306654252;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof AndBiPredicate) {
                AndBiPredicate that = (AndBiPredicate)obj;
                return this.components.equals(that.components);
            }
            return false;
        }

        public String toString() {
            return "Predicates.and(" + COMMA_JOINER.join(this.components) + ")";
        }
    }

    private static class NotBiPredicate<T, U>
    implements BiPredicate<T, U> {
        final BiPredicate<T, U> predicate;

        NotBiPredicate(BiPredicate<T, U> predicate) {
            this.predicate = (BiPredicate)Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean test(T t, U u) {
            return !this.predicate.test(t, u);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NotBiPredicate) {
                NotBiPredicate that = (NotBiPredicate)obj;
                return this.predicate.equals(that.predicate);
            }
            return false;
        }

        public String toString() {
            return "BiPredicates.not(" + this.predicate + ")";
        }
    }

    static enum ObjectBiPredicate implements BiPredicate<Object, Object>
    {
        ALWAYS_TRUE{

            @Override
            public boolean test(Object o1, Object o2) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public boolean test(Object o1, Object o2) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        };


        <T, U> BiPredicate<T, U> withNarrowedType() {
            return this;
        }
    }
}

