/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.PrimitiveUtils;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMManager {
    public static String REGEX_NOTCH_FROM_MCP = "!&!";

    public static boolean obf() {
        return FMLForgePlugin.RUNTIME_DEOBF;
    }

    public static String chooseByEnvironment(String deobf, String obf) {
        return ASMManager.obf() ? obf : deobf;
    }

    public static boolean strictCompareByEnvironment(String name, String deobf, String obf) {
        String comparedTo = ASMManager.chooseByEnvironment(deobf.replace('/', '.'), obf.replace('/', '.'));
        return comparedTo.equalsIgnoreCase(name.replace('/', '.'));
    }

    public static boolean compareByEnvironment(String name, String deobf, String obf) {
        String comparedTo = ASMManager.chooseByEnvironment(deobf.replace('/', '.'), obf.replace('/', '.'));
        return comparedTo.toLowerCase().contains(name.replace('/', '.').toLowerCase());
    }

    public static boolean checkClassForFieldByName(ClassNode cn, String name) {
        return ASMManager.checkClassForFieldByName(cn, name, name);
    }

    public static FieldNode getFieldByName(ClassNode cn, String name) {
        return ASMManager.getFieldByName(cn, name, name);
    }

    public static boolean checkClassForFieldByName(ClassNode cn, String deobfName, String obfName) {
        return ASMManager.checkClassForField(cn, deobfName, obfName, null, null);
    }

    public static FieldNode getFieldByName(ClassNode cn, String deobfName, String obfName) {
        return ASMManager.getField(cn, deobfName, obfName, null, null);
    }

    public static boolean checkClassForField(ClassNode cn, String name, String desc) {
        return ASMManager.checkClassForField(cn, name, name, desc, desc);
    }

    public static FieldNode getField(ClassNode cn, String name, String desc) {
        return ASMManager.getField(cn, name, name, desc, desc);
    }

    public static boolean checkClassForField(ClassNode cn, String deobfName, String obfName, String deobfDesc, String obfDesc) {
        return ASMManager.getField(cn, deobfName, obfName, deobfDesc, obfDesc) != null;
    }

    public static FieldNode getField(ClassNode cn, String deobfName, String obfName, String deobfDesc, String obfDesc) {
        String fieldName = null;
        String fieldDesc = null;
        if (!PrimitiveUtils.checkSameAndNullStrings(deobfName, obfName)) {
            fieldName = ASMManager.chooseByEnvironment(deobfName, obfName);
        }
        if (!PrimitiveUtils.checkSameAndNullStrings(deobfDesc, obfDesc)) {
            fieldDesc = ASMManager.chooseByEnvironment(deobfDesc, obfDesc);
        }
        String additionalFN = "";
        if (fieldName != null && fieldName.indexOf(REGEX_NOTCH_FROM_MCP) != -1) {
            String[] sstr = fieldName.split(REGEX_NOTCH_FROM_MCP);
            fieldName = sstr[0];
            additionalFN = sstr[1];
        }
        String additionalFD = "";
        if (fieldDesc != null && fieldDesc.indexOf(REGEX_NOTCH_FROM_MCP) != -1) {
            String[] sstr = fieldDesc.split(REGEX_NOTCH_FROM_MCP);
            fieldDesc = sstr[0];
            additionalFD = sstr[1];
        }
        if (PrimitiveUtils.checkSameAndNullStrings(fieldName, fieldDesc)) {
            return null;
        }
        for (FieldNode fn : cn.fields) {
            if (fieldName != null && !fn.name.equals(fieldName) && !fn.name.equals(additionalFN) || fieldDesc != null && !fn.desc.equals(fieldDesc) && !fn.desc.equals(additionalFD)) continue;
            return fn;
        }
        return null;
    }

    public static boolean checkClassForMethodDesc(ClassNode cn, String desc) {
        return ASMManager.checkClassForMethodDesc(cn, desc, desc);
    }

    public static MethodNode getMethodByDesc(ClassNode cn, String desc) {
        return ASMManager.getMethodByDesc(cn, desc, desc);
    }

    public static boolean checkClassForMethodDesc(ClassNode cn, String deobfDesc, String obfDesc) {
        return ASMManager.checkClassForMethod(cn, null, null, deobfDesc, obfDesc);
    }

    public static MethodNode getMethodByDesc(ClassNode cn, String deobfDesc, String obfDesc) {
        return ASMManager.getMethod(cn, null, null, deobfDesc, obfDesc);
    }

    public static boolean checkClassForMethodName(ClassNode cn, String name) {
        return ASMManager.checkClassForMethodName(cn, name, name);
    }

    public static MethodNode getMethodByName(ClassNode cn, String name) {
        return ASMManager.getMethodByName(cn, name, name);
    }

    public static boolean checkClassForMethodName(ClassNode cn, String deobfName, String obfName) {
        return ASMManager.checkClassForMethod(cn, deobfName, obfName, null, null);
    }

    public static MethodNode getMethodByName(ClassNode cn, String deobfName, String obfName) {
        return ASMManager.getMethod(cn, deobfName, obfName, null, null);
    }

    public static boolean checkClassForMethod(ClassNode cn, String name, String desc) {
        return ASMManager.checkClassForMethod(cn, name, name, desc, desc);
    }

    public static MethodNode getMethod(ClassNode cn, String name, String desc) {
        return ASMManager.getMethod(cn, name, name, desc, desc);
    }

    public static MethodNode getMethod(ClassNode cn, String deobfName, String obfName, String deobfDesc, String obfDesc) {
        String methodName = null;
        String methodDesc = null;
        if (!PrimitiveUtils.checkSameAndNullStrings(deobfName, obfName)) {
            methodName = ASMManager.chooseByEnvironment(deobfName, obfName);
        }
        if (!PrimitiveUtils.checkSameAndNullStrings(deobfDesc, obfDesc)) {
            methodDesc = ASMManager.chooseByEnvironment(deobfDesc, obfDesc);
        }
        String additionalMN = "";
        if (methodName != null && methodName.contains(REGEX_NOTCH_FROM_MCP)) {
            String[] sstr = methodName.split(REGEX_NOTCH_FROM_MCP);
            methodName = sstr[0];
            additionalMN = sstr[1];
        }
        String additionalMD = "";
        if (methodDesc != null && methodDesc.contains(REGEX_NOTCH_FROM_MCP)) {
            String[] sstr = methodDesc.split(REGEX_NOTCH_FROM_MCP);
            methodDesc = sstr[0];
            additionalMD = sstr[1];
        }
        if (PrimitiveUtils.checkSameAndNullStrings(methodName, methodDesc)) {
            return null;
        }
        for (MethodNode mn : cn.methods) {
            if (methodName != null && !methodName.equals(mn.name) && !additionalMN.equals(mn.name) || methodDesc != null && !methodDesc.equals(mn.desc) && !additionalMD.equals(mn.desc)) continue;
            return mn;
        }
        return null;
    }

    public static boolean checkClassForMethod(ClassNode cn, String deobfName, String obfName, String deobfDesc, String obfDesc) {
        return ASMManager.getMethod(cn, deobfName, obfName, deobfDesc, obfDesc) != null;
    }

    public static boolean checkAnnotationForClass(ClassNode cn, String name) {
        return ASMManager.checkAnnotationForClass(cn, name, name);
    }

    public static boolean checkAnnotationForClass(ClassNode cn, String deobfName, String obfName) {
        String searchedFor = ASMManager.chooseByEnvironment(deobfName, obfName);
        if (cn.invisibleAnnotations != null && cn.invisibleAnnotations.size() > 0) {
            for (AnnotationNode an : cn.invisibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        if (cn.visibleAnnotations != null && cn.visibleAnnotations.size() > 0) {
            for (AnnotationNode an : cn.visibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAnnotationForMethod(MethodNode mn, String name) {
        return ASMManager.checkAnnotationForMethod(mn, name, name);
    }

    public static boolean checkAnnotationForMethod(MethodNode mn, String deobfName, String obfName) {
        String searchedFor = ASMManager.chooseByEnvironment(deobfName, obfName);
        if (mn.invisibleAnnotations != null && mn.invisibleAnnotations.size() > 0) {
            for (AnnotationNode an : mn.invisibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        if (mn.visibleAnnotations != null && mn.visibleAnnotations.size() > 0) {
            for (AnnotationNode an : mn.visibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAnnotationForField(FieldNode fn, String name) {
        return ASMManager.checkAnnotationForField(fn, name, name);
    }

    public static boolean checkAnnotationForField(FieldNode fn, String deobfName, String obfName) {
        String searchedFor = ASMManager.chooseByEnvironment(deobfName, obfName);
        if (fn.invisibleAnnotations != null && fn.invisibleAnnotations.size() > 0) {
            for (AnnotationNode an : fn.invisibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        if (fn.visibleAnnotations != null && fn.visibleAnnotations.size() > 0) {
            for (AnnotationNode an : fn.visibleAnnotations) {
                if (!an.desc.equals(searchedFor)) continue;
                return true;
            }
        }
        return false;
    }
}

